/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAttribute;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public abstract class TableResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator {
    static final PathElement WILDCARD_PATH = TableResourceDefinition.pathElement("*");
    static final BinaryServiceDescriptor<TableManipulationConfiguration> SERVICE_DESCRIPTOR = BinaryServiceDescriptor.of((String)(StoreResourceDefinition.SERVICE_DESCRIPTOR.getName() + "." + WILDCARD_PATH.getKey()), TableManipulationConfiguration.class);
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setAllowMultipleRegistrations(true).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.GREATGRANDPARENT_GRANDPARENT).build();
    private final org.jboss.as.clustering.controller.Attribute prefixAttribute;

    static PathElement pathElement(String value) {
        return PathElement.pathElement((String)"table", (String)value);
    }

    TableResourceDefinition(PathElement path, org.jboss.as.clustering.controller.Attribute prefixAttribute) {
        super(path, (ResourceDescriptionResolver)InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(path, WILDCARD_PATH));
        this.prefixAttribute = prefixAttribute;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(new org.jboss.as.clustering.controller.Attribute[]{this.prefixAttribute}).addAttributes(Attribute.class).addAttributes(ColumnAttribute.class).addCapabilities(List.of(CAPABILITY));
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final EnumMap<ColumnAttribute, AbstractMap.SimpleImmutableEntry<String, String>> columns = new EnumMap<ColumnAttribute, AbstractMap.SimpleImmutableEntry<String, String>>(ColumnAttribute.class);
        for (ColumnAttribute column : EnumSet.allOf(ColumnAttribute.class)) {
            ModelNode columnModel = column.resolveModelAttribute((ExpressionResolver)context, model);
            String name = column.getColumnName().resolveModelAttribute((ExpressionResolver)context, columnModel).asString();
            String type = column.getColumnType().resolveModelAttribute((ExpressionResolver)context, columnModel).asString();
            columns.put(column, new AbstractMap.SimpleImmutableEntry<String, String>(name, type));
        }
        final int fetchSize = Attribute.FETCH_SIZE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final String prefix = this.prefixAttribute.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final boolean createOnStart = Attribute.CREATE_ON_START.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final boolean dropOnStop = Attribute.DROP_ON_STOP.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        Supplier<TableManipulationConfiguration> configurationFactory = new Supplier<TableManipulationConfiguration>(){

            @Override
            public TableManipulationConfiguration get() {
                return ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).table().createOnStart(createOnStart)).dropOnExit(dropOnStop)).idColumnName((String)((Map.Entry)columns.get((Object)ColumnAttribute.ID)).getKey())).idColumnType((String)((Map.Entry)columns.get((Object)ColumnAttribute.ID)).getValue())).dataColumnName((String)((Map.Entry)columns.get((Object)ColumnAttribute.DATA)).getKey())).dataColumnType((String)((Map.Entry)columns.get((Object)ColumnAttribute.DATA)).getValue())).segmentColumnName((String)((Map.Entry)columns.get((Object)ColumnAttribute.SEGMENT)).getKey())).segmentColumnType((String)((Map.Entry)columns.get((Object)ColumnAttribute.SEGMENT)).getValue())).timestampColumnName((String)((Map.Entry)columns.get((Object)ColumnAttribute.TIMESTAMP)).getKey())).timestampColumnType((String)((Map.Entry)columns.get((Object)ColumnAttribute.TIMESTAMP)).getValue())).fetchSize(fetchSize)).tableNamePrefix(prefix)).create();
            }
        };
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(CAPABILITY, (Supplier)configurationFactory).build();
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        FETCH_SIZE("fetch-size", ModelType.INT, new ModelNode(100)),
        CREATE_ON_START("create-on-start", ModelType.BOOLEAN, ModelNode.TRUE),
        DROP_ON_STOP("drop-on-stop", ModelType.BOOLEAN, ModelNode.FALSE);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum ColumnAttribute implements org.jboss.as.clustering.controller.Attribute
    {
        ID("id-column", "id", "VARCHAR"),
        DATA("data-column", "datum", "BINARY"),
        SEGMENT("segment-column", "segment", "INTEGER"),
        TIMESTAMP("timestamp-column", "version", "BIGINT");

        private final org.jboss.as.clustering.controller.Attribute name;
        private final org.jboss.as.clustering.controller.Attribute type;
        private final AttributeDefinition definition;

        private ColumnAttribute(String name, String defaultName, String defaultType) {
            this.name = new SimpleAttribute((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode(defaultName))).build());
            this.type = new SimpleAttribute((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode(defaultType))).build());
            this.definition = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)name, (AttributeDefinition[])new AttributeDefinition[]{(AttributeDefinition)this.name.getDefinition(), (AttributeDefinition)this.type.getDefinition()}).setRequired(false)).setSuffix("column").build();
        }

        org.jboss.as.clustering.controller.Attribute getColumnName() {
            return this.name;
        }

        org.jboss.as.clustering.controller.Attribute getColumnType() {
            return this.type;
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

