/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.infinispan.commons.configuration.Builder;
import org.jboss.as.clustering.infinispan.subsystem.ConfigurationResourceServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinitionRegistrar;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SubsystemModel;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ServiceDependency;

public abstract class ConfigurationResourceDefinitionRegistrar<C, B extends Builder<C>>
implements ChildResourceDefinitionRegistrar,
ResourceModelResolver<ServiceDependency<B>>,
UnaryOperator<ResourceDescriptor.Builder>,
Supplier<ResourceOperationRuntimeHandler> {
    private final ResourceRegistration registration;
    private final RuntimeCapability<Void> capability;
    private final ResourceOperationRuntimeHandler runtimeHandler;
    private final InfinispanSubsystemModel deprecation;

    public ConfigurationResourceDefinitionRegistrar(Configurator<C> configurator) {
        this.registration = configurator.getResourceRegistration();
        this.capability = configurator.getCapability();
        this.runtimeHandler = ResourceOperationRuntimeHandler.configureService(new ConfigurationResourceServiceConfigurator(configurator, this));
        this.deprecation = configurator.getDeprecation();
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)builder.addCapability(this.capability)).withRuntimeHandler(this.get());
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        PathElement path = this.registration.getPathElement();
        ParentResourceDescriptionResolver resolver = InfinispanSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(path, PathElement.pathElement((String)path.getKey()));
        ResourceDescriptor descriptor = this.apply(ResourceDescriptor.builder((ResourceDescriptionResolver)resolver)).build();
        ResourceDefinition definition = ResourceDefinition.builder((ResourceRegistration)this.registration, (ResourceDescriptionResolver)resolver, (SubsystemModel)this.deprecation).build();
        ManagementResourceRegistration registration = parent.registerSubModel(definition);
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        return registration;
    }

    @Override
    public ResourceOperationRuntimeHandler get() {
        return this.runtimeHandler;
    }

    public static interface Configurator<C>
    extends ConfigurationResourceServiceConfigurator.Configurator<C> {
        public ResourceRegistration getResourceRegistration();

        default public InfinispanSubsystemModel getDeprecation() {
            return null;
        }
    }
}

