/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.invoker;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.SystemException;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.concurrent.TimeoutException;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.SimpleCacheInvoker;

public class RetryingCacheInvoker
implements CacheInvoker {
    private static final Set<Integer> ALLOWED_RETRY_STATUS = new HashSet<Integer>(Arrays.asList(6, 0, 8, 7));
    private final CacheInvoker invoker;
    private final int[] backOffIntervals;

    public RetryingCacheInvoker(int ... backOffIntervals) {
        this(new SimpleCacheInvoker(), backOffIntervals);
    }

    public RetryingCacheInvoker(CacheInvoker invoker, int ... backOffIntervals) {
        this.invoker = invoker;
        this.backOffIntervals = backOffIntervals;
    }

    @Override
    public <K, V, R> R invoke(Cache<K, V> cache, CacheInvoker.Operation<K, V, R> operation, Flag ... allFlags) {
        Flag[] attemptFlags = null;
        if (allFlags != null && allFlags.length > 0) {
            EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
            flags.addAll(Arrays.asList(allFlags));
            flags.remove(Flag.FAIL_SILENTLY);
            attemptFlags = flags.toArray(new Flag[flags.size()]);
        }
        Throwable exception = null;
        for (int i = 0; i <= this.backOffIntervals.length; ++i) {
            boolean retry = i < this.backOffIntervals.length;
            try {
                return this.invoker.invoke(cache, operation, retry ? attemptFlags : allFlags);
            }
            catch (SuspectException | TimeoutException e) {
                exception = e;
                if (cache.getCacheConfiguration().transaction().transactionMode().isTransactional()) {
                    try {
                        int status = cache.getAdvancedCache().getTransactionManager().getStatus();
                        if (!ALLOWED_RETRY_STATUS.contains(status)) {
                            throw e;
                        }
                    }
                    catch (SystemException se) {
                        throw e;
                    }
                }
                if (!retry) continue;
                int delay = this.backOffIntervals[i];
                if (InfinispanLogger.ROOT_LOGGER.isTraceEnabled()) {
                    InfinispanLogger.ROOT_LOGGER.tracef(exception, "Cache operation failed.  Retrying in %d ms", delay);
                }
                if (delay > 0) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    Thread.yield();
                }
                if (Thread.currentThread().isInterrupted()) break;
                continue;
            }
        }
        throw InfinispanMessages.MESSAGES.abortingCacheOperation(exception, this.backOffIntervals.length);
    }
}

