/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.interceptors.ActivationInterceptor;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.infinispan.interceptors.InvalidationInterceptor;
import org.infinispan.interceptors.PassivationInterceptor;
import org.infinispan.interceptors.TxInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.util.concurrent.locks.LockManagerImpl;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class CacheMetricsHandler
extends AbstractRuntimeOnlyHandler {
    public static final CacheMetricsHandler INSTANCE = new CacheMetricsHandler();

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        int containerIndex = CacheMetricsHandler.getCacheContainerIndex(address);
        String cacheContainerName = address.getElement(containerIndex).getValue();
        String cacheName = address.getElement(containerIndex + 1).getValue();
        String attrName = operation.require("name").asString();
        CacheMetrics metric = CacheMetrics.getStat(attrName);
        ServiceController controller = context.getServiceRegistry(false).getService(CacheService.getServiceName(cacheContainerName, cacheName));
        boolean started = controller != null && controller.getValue() != null;
        ModelNode result = new ModelNode();
        if (metric == null) {
            context.getFailureDescription().set(InfinispanMessages.MESSAGES.unknownMetric(attrName));
        } else if (started) {
            Cache cache = (Cache)controller.getValue();
            switch (metric) {
                case CACHE_STATUS: {
                    result.set(cache.getAdvancedCache().getStatus().toString());
                    break;
                }
                case CONCURRENCY_LEVEL: {
                    result.set(((LockManagerImpl)cache.getAdvancedCache().getLockManager()).getConcurrencyLevel());
                    break;
                }
                case NUMBER_OF_LOCKS_AVAILABLE: {
                    result.set(((LockManagerImpl)cache.getAdvancedCache().getLockManager()).getNumberOfLocksAvailable());
                    break;
                }
                case NUMBER_OF_LOCKS_HELD: {
                    result.set(((LockManagerImpl)cache.getAdvancedCache().getLockManager()).getNumberOfLocksHeld());
                    break;
                }
                case AVERAGE_READ_TIME: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getAverageReadTime() : 0L);
                    break;
                }
                case AVERAGE_WRITE_TIME: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getAverageWriteTime() : 0L);
                    break;
                }
                case ELAPSED_TIME: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getElapsedTime() : 0L);
                    break;
                }
                case EVICTIONS: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getEvictions() : 0L);
                    break;
                }
                case HIT_RATIO: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getHitRatio() : 0.0);
                    break;
                }
                case HITS: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getHits() : 0L);
                    break;
                }
                case MISSES: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getMisses() : 0L);
                    break;
                }
                case NUMBER_OF_ENTRIES: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getNumberOfEntries() : 0);
                    break;
                }
                case READ_WRITE_RATIO: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getReadWriteRatio() : 0.0);
                    break;
                }
                case REMOVE_HITS: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getRemoveHits() : 0L);
                    break;
                }
                case REMOVE_MISSES: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getRemoveMisses() : 0L);
                    break;
                }
                case STORES: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getStores() : 0L);
                    break;
                }
                case TIME_SINCE_RESET: {
                    CacheMgmtInterceptor cacheMgmtInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), CacheMgmtInterceptor.class);
                    result.set(cacheMgmtInterceptor != null ? cacheMgmtInterceptor.getTimeSinceReset() : 0L);
                    break;
                }
                case AVERAGE_REPLICATION_TIME: {
                    result.set(((RpcManagerImpl)cache.getAdvancedCache().getRpcManager()).getAverageReplicationTime());
                    break;
                }
                case REPLICATION_COUNT: {
                    result.set(((RpcManagerImpl)cache.getAdvancedCache().getRpcManager()).getReplicationCount());
                    break;
                }
                case REPLICATION_FAILURES: {
                    result.set(((RpcManagerImpl)cache.getAdvancedCache().getRpcManager()).getReplicationFailures());
                    break;
                }
                case SUCCESS_RATIO: {
                    result.set(((RpcManagerImpl)cache.getAdvancedCache().getRpcManager()).getSuccessRatioFloatingPoint());
                    break;
                }
                case COMMITS: {
                    TxInterceptor txInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), TxInterceptor.class);
                    result.set(txInterceptor != null ? txInterceptor.getCommits() : 0L);
                    break;
                }
                case PREPARES: {
                    TxInterceptor txInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), TxInterceptor.class);
                    result.set(txInterceptor != null ? txInterceptor.getPrepares() : 0L);
                    break;
                }
                case ROLLBACKS: {
                    TxInterceptor txInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), TxInterceptor.class);
                    result.set(txInterceptor != null ? txInterceptor.getRollbacks() : 0L);
                    break;
                }
                case INVALIDATIONS: {
                    InvalidationInterceptor invInterceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), InvalidationInterceptor.class);
                    result.set(invInterceptor != null ? invInterceptor.getInvalidations() : 0L);
                    break;
                }
                case PASSIVATIONS: {
                    PassivationInterceptor interceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), PassivationInterceptor.class);
                    result.set(interceptor != null ? interceptor.getPassivations() : "");
                    break;
                }
                case ACTIVATIONS: {
                    ActivationManager manager = (ActivationManager)cache.getAdvancedCache().getComponentRegistry().getComponent(ActivationManager.class);
                    result.set(manager != null ? manager.getActivationCount() : 0L);
                    break;
                }
                case CACHE_LOADER_LOADS: {
                    ActivationInterceptor interceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), ActivationInterceptor.class);
                    result.set(interceptor != null ? interceptor.getCacheLoaderLoads() : 0L);
                    break;
                }
                case CACHE_LOADER_MISSES: {
                    ActivationInterceptor interceptor = CacheMetricsHandler.getFirstInterceptorWhichExtends(cache.getAdvancedCache().getInterceptorChain(), ActivationInterceptor.class);
                    result.set(interceptor != null ? interceptor.getCacheLoaderMisses() : 0L);
                    break;
                }
            }
            context.getResult().set(result);
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }

    private static int getCacheContainerIndex(PathAddress address) {
        int index = 0;
        for (PathElement element : address) {
            if (element.getKey().equals("cache-container")) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static <T extends CommandInterceptor> T getFirstInterceptorWhichExtends(List<CommandInterceptor> interceptors, Class<T> interceptorClass) {
        for (CommandInterceptor interceptor : interceptors) {
            boolean isSubclass = interceptorClass.isAssignableFrom(interceptor.getClass());
            if (!isSubclass) continue;
            Collections.emptyList();
            return (T)((CommandInterceptor)interceptorClass.cast(interceptor));
        }
        return null;
    }

    public static enum CacheMetrics {
        CACHE_STATUS(CacheResourceDefinition.CACHE_STATUS),
        NUMBER_OF_LOCKS_AVAILABLE(LockingResourceDefinition.NUMBER_OF_LOCKS_AVAILABLE),
        NUMBER_OF_LOCKS_HELD(LockingResourceDefinition.NUMBER_OF_LOCKS_HELD),
        CONCURRENCY_LEVEL(LockingResourceDefinition.CURRENT_CONCURRENCY_LEVEL),
        AVERAGE_READ_TIME(CacheResourceDefinition.AVERAGE_READ_TIME),
        AVERAGE_WRITE_TIME(CacheResourceDefinition.AVERAGE_WRITE_TIME),
        ELAPSED_TIME(CacheResourceDefinition.ELAPSED_TIME),
        EVICTIONS(EvictionResourceDefinition.EVICTIONS),
        HIT_RATIO(CacheResourceDefinition.HIT_RATIO),
        HITS(CacheResourceDefinition.HITS),
        MISSES(CacheResourceDefinition.MISSES),
        NUMBER_OF_ENTRIES(CacheResourceDefinition.NUMBER_OF_ENTRIES),
        READ_WRITE_RATIO(CacheResourceDefinition.READ_WRITE_RATIO),
        REMOVE_HITS(CacheResourceDefinition.REMOVE_HITS),
        REMOVE_MISSES(CacheResourceDefinition.REMOVE_MISSES),
        STORES(CacheResourceDefinition.STORES),
        TIME_SINCE_RESET(CacheResourceDefinition.TIME_SINCE_RESET),
        AVERAGE_REPLICATION_TIME(ClusteredCacheResourceDefinition.AVERAGE_REPLICATION_TIME),
        REPLICATION_COUNT(ClusteredCacheResourceDefinition.REPLICATION_COUNT),
        REPLICATION_FAILURES(ClusteredCacheResourceDefinition.REPLICATION_FAILURES),
        SUCCESS_RATIO(ClusteredCacheResourceDefinition.SUCCESS_RATIO),
        COMMITS(TransactionResourceDefinition.COMMITS),
        PREPARES(TransactionResourceDefinition.PREPARES),
        ROLLBACKS(TransactionResourceDefinition.ROLLBACKS),
        INVALIDATIONS(CacheResourceDefinition.INVALIDATIONS),
        PASSIVATIONS(CacheResourceDefinition.PASSIVATIONS),
        ACTIVATIONS(CacheResourceDefinition.ACTIVATIONS),
        CACHE_LOADER_LOADS(StoreResourceDefinition.CACHE_LOADER_LOADS),
        CACHE_LOADER_MISSES(StoreResourceDefinition.CACHE_LOADER_MISSES);

        private static final Map<String, CacheMetrics> MAP;
        final AttributeDefinition definition;

        private CacheMetrics(AttributeDefinition definition) {
            this.definition = definition;
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static CacheMetrics getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, CacheMetrics>();
            for (CacheMetrics metric : CacheMetrics.values()) {
                MAP.put(metric.toString(), metric);
            }
        }
    }
}

