/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.clustering.controller.RemoveStepHandlerDescriptor;
import org.jboss.as.clustering.controller.RequiredCapability;
import org.jboss.as.clustering.controller.Requirement;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.RestartParentResourceAddStepHandler;
import org.jboss.as.clustering.controller.RestartParentResourceRemoveStepHandler;
import org.jboss.as.clustering.controller.RestartParentResourceWriteAttributeHandler;
import org.jboss.as.clustering.controller.SimpleAliasEntry;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.transform.PathAddressTransformer;
import org.jboss.as.clustering.controller.transform.SimpleAddOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleDescribeOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleReadAttributeOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleRemoveOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleResourceTransformer;
import org.jboss.as.clustering.controller.transform.SimpleUndefineAttributeOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleWriteAttributeOperationTransformer;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportConfigurationBuilderFactory;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class TransportResourceDefinition
extends ProtocolResourceDefinition {
    static final PathElement LEGACY_PATH = TransportResourceDefinition.pathElement("TRANSPORT");
    static final PathElement WILDCARD_PATH = TransportResourceDefinition.pathElement("*");
    static final PathAddressTransformer LEGACY_ADDRESS_TRANSFORMER = new PathAddressTransformer(){

        public PathAddress transform(PathAddress address) {
            return address.subAddress(0, address.size() - 1).append(new PathElement[]{LEGACY_PATH});
        }
    };

    static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"transport", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        ProtocolResourceDefinition.addTransformations(version, builder);
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter(Attribute.SHARED.getDefinition()), new AttributeDefinition[]{Attribute.SHARED.getDefinition()});
            builder.setCustomResourceTransformer((ResourceTransformer)new SimpleResourceTransformer(LEGACY_ADDRESS_TRANSFORMER));
            builder.addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)new SimpleAddOperationTransformer(LEGACY_ADDRESS_TRANSFORMER).addAttributes(Attribute.class).addAttributes(ThreadingAttribute.class).addAttributes(ProtocolResourceDefinition.Attribute.class)).inheritResourceAttributeDefinitions();
            builder.addOperationTransformationOverride("remove").setCustomOperationTransformer((OperationTransformer)new SimpleRemoveOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            builder.addOperationTransformationOverride("read-attribute").setCustomOperationTransformer((OperationTransformer)new SimpleReadAttributeOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            builder.addOperationTransformationOverride("write-attribute").setCustomOperationTransformer((OperationTransformer)new SimpleWriteAttributeOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            builder.addOperationTransformationOverride("undefine-attribute").setCustomOperationTransformer((OperationTransformer)new SimpleUndefineAttributeOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            builder.addOperationTransformationOverride("describe").setCustomOperationTransformer((OperationTransformer)new SimpleDescribeOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            builder.rejectChildResource(ThreadPoolResourceDefinition.WILDCARD_PATH);
        } else {
            for (ThreadPoolResourceDefinition pool : ThreadPoolResourceDefinition.values()) {
                pool.buildTransformation(version, parent);
            }
        }
        PropertyResourceDefinition.buildTransformation(version, builder);
    }

    TransportResourceDefinition(ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        super(new SimpleResourceDefinition.Parameters(WILDCARD_PATH, (ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver(WILDCARD_PATH, ProtocolResourceDefinition.WILDCARD_PATH)), parentBuilderFactory);
    }

    @Override
    public void registerOperations(ManagementResourceRegistration registration) {
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addAttributes(ThreadingAttribute.class).addAttributes(ProtocolResourceDefinition.Attribute.class).addCapabilities(Capability.class).addCapabilities(ProtocolResourceDefinition.Capability.class);
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceBuilderFactory)new TransportConfigurationBuilderFactory());
        new RestartParentResourceAddStepHandler(this.parentBuilderFactory, (AddStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
        new RestartParentResourceRemoveStepHandler(this.parentBuilderFactory, (RemoveStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration registration) {
        super.registerAttributes(registration);
        new RestartParentResourceWriteAttributeHandler(this.parentBuilderFactory, Attribute.class).register(registration);
        new ReloadRequiredWriteAttributeHandler(ThreadingAttribute.class){

            protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ModelNode conf = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                        if (context.getProcessType().isServer()) {
                            for (ThreadingAttribute attribute : ThreadingAttribute.values()) {
                                if (!conf.hasDefined(attribute.getDefinition().getName())) continue;
                                throw new OperationFailedException(JGroupsLogger.ROOT_LOGGER.threadsAttributesUsedInRuntime());
                            }
                        }
                    }
                }, OperationContext.Stage.MODEL);
            }
        }.register(registration);
    }

    @Override
    public void registerChildren(ManagementResourceRegistration registration) {
        super.registerChildren(registration);
        for (ThreadPoolResourceDefinition pool : ThreadPoolResourceDefinition.values()) {
            pool.register(registration);
        }
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        registration.registerAlias(LEGACY_PATH, (AliasEntry)new SimpleAliasEntry(registration.registerSubModel((ResourceDefinition)this)));
    }

    @Deprecated
    static enum ThreadingAttribute implements org.jboss.as.clustering.controller.Attribute
    {
        DEFAULT_EXECUTOR("default-executor"),
        OOB_EXECUTOR("oob-executor"),
        TIMER_EXECUTOR("timer-executor"),
        THREAD_FACTORY("thread-factory");

        private final AttributeDefinition definition;

        private ThreadingAttribute(String name) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, ModelType.STRING).setAllowExpression(false)).setAllowNull(true)).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        SHARED("shared", ModelType.BOOLEAN, new ModelNode(false)),
        DIAGNOSTICS_SOCKET_BINDING("diagnostics-socket-binding", ModelType.STRING, (AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF, (CapabilityReferenceRecorder)new CapabilityReference((Requirement)RequiredCapability.SOCKET_BINDING, (org.jboss.as.clustering.controller.Capability)Capability.DIAGNOSTICS_SOCKET_BINDING)),
        SITE("site", ModelType.STRING),
        RACK("rack", ModelType.STRING),
        MACHINE("machine", ModelType.STRING);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = Attribute.createBuilder(name, type).build();
        }

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)Attribute.createBuilder(name, type).setDefaultValue(defaultValue)).build();
        }

        private Attribute(String name, ModelType type, AccessConstraintDefinition constraint, CapabilityReferenceRecorder reference) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)Attribute.createBuilder(name, type).setAccessConstraints(new AccessConstraintDefinition[]{constraint})).setCapabilityReference(reference)).build();
        }

        private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type) {
            return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setAllowNull(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES});
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    private static enum Capability implements org.jboss.as.clustering.controller.Capability
    {
        DIAGNOSTICS_SOCKET_BINDING("org.wildfly.clustering.transport.diagnostics-socket-binding", SocketBinding.class);

        private final RuntimeCapability<Void> definition;

        private Capability(String name, Class<?> serviceType) {
            this.definition = RuntimeCapability.Builder.of((String)name, (boolean)true).setServiceType(serviceType).build();
        }

        public RuntimeCapability<Void> getDefinition() {
            return this.definition;
        }

        public RuntimeCapability<Void> getRuntimeCapability(PathAddress address) {
            PathAddress stackAddress = address.getParent();
            return this.definition.fromBaseCapability(stackAddress.getLastElement().getValue() + "." + address.getLastElement().getValue());
        }
    }
}

