/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.clustering.controller.RemoveStepHandlerDescriptor;
import org.jboss.as.clustering.controller.RequiredCapability;
import org.jboss.as.clustering.controller.Requirement;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.RestartParentResourceAddStepHandler;
import org.jboss.as.clustering.controller.RestartParentResourceRemoveStepHandler;
import org.jboss.as.clustering.controller.SimpleAliasEntry;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.transform.ChainedOperationTransformer;
import org.jboss.as.clustering.controller.transform.ImplicitlyAddedResourceDynamicDiscardPolicy;
import org.jboss.as.clustering.controller.transform.OperationTransformer;
import org.jboss.as.clustering.controller.transform.PathAddressTransformer;
import org.jboss.as.clustering.controller.transform.SimpleDescribeOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimplePathOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleReadAttributeOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleRemoveOperationTransformer;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportConfigurationBuilderFactory;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.DynamicDiscardPolicy;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class TransportResourceDefinition
extends ProtocolResourceDefinition {
    static final PathElement LEGACY_PATH = TransportResourceDefinition.pathElement("TRANSPORT");
    static final PathElement WILDCARD_PATH = TransportResourceDefinition.pathElement("*");
    static final PathAddressTransformer LEGACY_ADDRESS_TRANSFORMER = new PathAddressTransformer(){

        public PathAddress transform(PathAddress address) {
            return address.subAddress(0, address.size() - 1).append(new PathElement[]{LEGACY_PATH});
        }
    };

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"transport", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        ProtocolResourceDefinition.addTransformations(version, builder);
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter(Attribute.SHARED.getDefinition()), new AttributeDefinition[]{Attribute.SHARED.getDefinition()});
            builder.setCustomResourceTransformer(new ResourceTransformer(){

                public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                    PropertyResourceDefinition.PROPERTIES_RESOURCE_TRANSFORMER.transformResource(context, LEGACY_ADDRESS_TRANSFORMER.transform(address), resource);
                }
            });
            builder.addOperationTransformationOverride("add").setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    operation.get("address").set(LEGACY_ADDRESS_TRANSFORMER.transform(Operations.getPathAddress((ModelNode)operation)).toModelNode());
                    return PropertyResourceDefinition.PROPERTIES_ADD_OP_TRANSFORMER.transformOperation(operation);
                }
            })).inheritResourceAttributeDefinitions();
            builder.addOperationTransformationOverride("remove").setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new SimpleRemoveOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            builder.addOperationTransformationOverride("read-attribute").setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new SimpleReadAttributeOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            builder.addOperationTransformationOverride("describe").setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new SimpleDescribeOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            OperationTransformer getPropertyTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    if (operation.get("name").asString().equals(ProtocolResourceDefinition.Attribute.PROPERTIES.getDefinition().getName())) {
                        String key = operation.get("key").asString();
                        PathAddress address = LEGACY_ADDRESS_TRANSFORMER.transform(Operations.getPathAddress((ModelNode)operation));
                        ModelNode transformedOperation = Util.createOperation((String)"read-attribute", (PathAddress)address.append(new PathElement[]{PropertyResourceDefinition.pathElement(key)}));
                        transformedOperation.get("name").set(PropertyResourceDefinition.VALUE.getName());
                        return transformedOperation;
                    }
                    return operation;
                }
            };
            builder.addRawOperationTransformationOverride(MapOperations.MAP_GET_DEFINITION.getName(), (org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(getPropertyTransformer));
            LinkedList<Object> transformerChain = new LinkedList<Object>();
            transformerChain.add(new SimplePathOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            transformerChain.add(PropertyResourceDefinition.PROPERTIES_OP_TRANSFORMER);
            ChainedOperationTransformer chainedTransformer = new ChainedOperationTransformer(transformerChain, false);
            HashSet<String> writeAttributeOperations = new HashSet<String>(MapOperations.MAP_OPERATION_NAMES);
            writeAttributeOperations.remove(MapOperations.MAP_GET_DEFINITION.getName());
            writeAttributeOperations.add("write-attribute");
            writeAttributeOperations.add("undefine-attribute");
            for (String opName : writeAttributeOperations) {
                builder.addOperationTransformationOverride(opName).inheritResourceAttributeDefinitions().setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)chainedTransformer);
            }
            builder.addChildResource(ThreadPoolResourceDefinition.WILDCARD_PATH, (DynamicDiscardPolicy)new ImplicitlyAddedResourceDynamicDiscardPolicy());
        } else {
            Stream.of(ThreadPoolResourceDefinition.values()).forEach(p -> p.buildTransformation(version, parent));
        }
        PropertyResourceDefinition.buildTransformation(version, builder);
    }

    TransportResourceDefinition(ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        super(new SimpleResourceDefinition.Parameters(WILDCARD_PATH, (ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver(WILDCARD_PATH, ProtocolResourceDefinition.WILDCARD_PATH)), parentBuilderFactory);
    }

    @Override
    public void register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        parentRegistration.registerAlias(LEGACY_PATH, (AliasEntry)new SimpleAliasEntry(registration));
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addAttributes(ProtocolResourceDefinition.Attribute.class).addExtraParameters(ThreadingAttribute.class).addExtraParameters(ProtocolResourceDefinition.DeprecatedAttribute.class).addCapabilities(Capability.class).addCapabilities(ProtocolResourceDefinition.Capability.class);
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceBuilderFactory)new TransportConfigurationBuilderFactory());
        new RestartParentResourceAddStepHandler<ChannelFactory>(this.parentBuilderFactory, (AddStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler){

            protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
                super.populateModel(operation, model);
                for (ThreadingAttribute attribute : EnumSet.allOf(ThreadingAttribute.class)) {
                    attribute.getDefinition().validateAndSet(operation, model);
                }
            }
        }.register(registration);
        new RestartParentResourceRemoveStepHandler(this.parentBuilderFactory, (RemoveStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
        new ReloadRequiredWriteAttributeHandler(() -> EnumSet.allOf(ThreadingAttribute.class).stream().map(attribute -> attribute.getDefinition()).collect(Collectors.toList())){

            protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ModelNode conf = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                        if (context.getProcessType().isServer()) {
                            for (ThreadingAttribute attribute : EnumSet.allOf(ThreadingAttribute.class)) {
                                if (!conf.hasDefined(attribute.getDefinition().getName())) continue;
                                throw new OperationFailedException(JGroupsLogger.ROOT_LOGGER.threadsAttributesUsedInRuntime());
                            }
                        }
                    }
                }, OperationContext.Stage.MODEL);
            }
        }.register(registration);
        EnumSet.allOf(ThreadPoolResourceDefinition.class).forEach(pool -> pool.register(registration));
        super.register(registration);
    }

    @Deprecated
    static enum ThreadingAttribute implements org.jboss.as.clustering.controller.Attribute
    {
        DEFAULT_EXECUTOR("default-executor"),
        OOB_EXECUTOR("oob-executor"),
        TIMER_EXECUTOR("timer-executor"),
        THREAD_FACTORY("thread-factory");

        private final AttributeDefinition definition;

        private ThreadingAttribute(String name) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, ModelType.STRING).setAllowExpression(false)).setAllowNull(true)).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        SHARED("shared", ModelType.BOOLEAN, new ModelNode(false)),
        DIAGNOSTICS_SOCKET_BINDING("diagnostics-socket-binding", ModelType.STRING, (AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF, (CapabilityReferenceRecorder)new CapabilityReference((Requirement)RequiredCapability.SOCKET_BINDING, (org.jboss.as.clustering.controller.Capability)Capability.DIAGNOSTICS_SOCKET_BINDING)),
        SITE("site", ModelType.STRING),
        RACK("rack", ModelType.STRING),
        MACHINE("machine", ModelType.STRING);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = Attribute.createBuilder(name, type).build();
        }

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)Attribute.createBuilder(name, type).setDefaultValue(defaultValue)).build();
        }

        private Attribute(String name, ModelType type, AccessConstraintDefinition constraint, CapabilityReferenceRecorder reference) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)Attribute.createBuilder(name, type).setAccessConstraints(new AccessConstraintDefinition[]{constraint})).setCapabilityReference(reference)).build();
        }

        private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type) {
            return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setAllowNull(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES});
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Capability implements org.jboss.as.clustering.controller.Capability
    {
        DIAGNOSTICS_SOCKET_BINDING("org.wildfly.clustering.transport.diagnostics-socket-binding", SocketBinding.class);

        private final RuntimeCapability<Void> definition;

        private Capability(String name, Class<?> serviceType) {
            this.definition = RuntimeCapability.Builder.of((String)name, (boolean)true).setServiceType(serviceType).build();
        }

        public RuntimeCapability<Void> getDefinition() {
            return this.definition;
        }

        public RuntimeCapability<Void> getRuntimeCapability(PathAddress address) {
            PathAddress stackAddress = address.getParent();
            return this.definition.fromBaseCapability(stackAddress.getLastElement().getValue() + "." + address.getLastElement().getValue());
        }
    }
}

