/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jgroups.Channel;
import org.jgroups.fork.ForkChannel;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;

public class ForkChannelFactory
implements ChannelFactory {
    private final ChannelFactory parentFactory;
    private final List<ProtocolConfiguration<? extends Protocol>> protocols;
    private final Channel channel;

    public ForkChannelFactory(Channel channel, ChannelFactory parentFactory, List<ProtocolConfiguration<? extends Protocol>> protocols) {
        this.channel = channel;
        this.parentFactory = parentFactory;
        this.protocols = protocols;
    }

    public Channel createChannel(String id) throws Exception {
        JGroupsLogger.ROOT_LOGGER.debugf("Creating fork channel %s from channel %s", id, this.channel.getClusterName());
        String stackName = this.protocols.isEmpty() ? this.channel.getClusterName() : id;
        return new ForkChannel(this.channel, stackName, id, (Protocol[])this.protocols.stream().map(pc -> pc.createProtocol(this.parentFactory.getProtocolStackConfiguration())).toArray(Protocol[]::new));
    }

    public ProtocolStackConfiguration getProtocolStackConfiguration() {
        List parentProtocols = this.parentFactory.getProtocolStackConfiguration().getProtocols();
        ArrayList<ProtocolConfiguration<? extends Protocol>> protocols = new ArrayList<ProtocolConfiguration<? extends Protocol>>(parentProtocols.size() + this.protocols.size());
        protocols.addAll(parentProtocols);
        protocols.addAll(this.protocols);
        return new ForkProtocolStackConfiguration(this.channel.getClusterName(), this.parentFactory.getProtocolStackConfiguration(), protocols);
    }

    public boolean isUnknownForkResponse(ByteBuffer response) {
        return this.parentFactory.isUnknownForkResponse(response);
    }

    private static class ForkProtocolStackConfiguration
    implements ProtocolStackConfiguration {
        private final String name;
        private final List<ProtocolConfiguration<? extends Protocol>> protocols;
        private final ProtocolStackConfiguration parentStack;

        ForkProtocolStackConfiguration(String name, ProtocolStackConfiguration parentStack, List<ProtocolConfiguration<? extends Protocol>> protocols) {
            this.name = name;
            this.protocols = protocols;
            this.parentStack = parentStack;
        }

        public String getName() {
            return this.name;
        }

        public boolean isStatisticsEnabled() {
            return this.parentStack.isStatisticsEnabled();
        }

        public List<ProtocolConfiguration<? extends Protocol>> getProtocols() {
            return this.protocols;
        }

        public TransportConfiguration<? extends TP> getTransport() {
            return this.parentStack.getTransport();
        }

        public String getNodeName() {
            return this.parentStack.getNodeName();
        }

        public RelayConfiguration getRelay() {
            return this.parentStack.getRelay();
        }
    }
}

