/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.jboss.as.clustering.controller.CapabilityProvider;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.UnaryRequirementCapability;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidatorBuilder;
import org.jboss.as.clustering.controller.validation.ParameterValidatorBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetric;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetricExecutor;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceHandler;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolRegistration;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceRegistrationHandler;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.DiscardPolicy;
import org.jboss.as.controller.transform.description.DynamicDiscardPolicy;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;

public class ChannelResourceDefinition
extends ChildResourceDefinition {
    public static final PathElement WILDCARD_PATH = ChannelResourceDefinition.pathElement("*");
    static final Map<ClusteringRequirement, org.jboss.as.clustering.controller.Capability> CLUSTERING_CAPABILITIES = new EnumMap<ClusteringRequirement, org.jboss.as.clustering.controller.Capability>(ClusteringRequirement.class);
    private final boolean allowRuntimeOnlyRegistration;

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"channel", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            DynamicDiscardPolicy channelDiscardRejectPolicy = new DynamicDiscardPolicy(){

                public DiscardPolicy checkResource(TransformationContext context, PathAddress address) {
                    Resource infinispanResource;
                    String channelName = address.getLastElement().getValue();
                    PathAddress rootAddress = address.subAddress(0, address.size() - 2);
                    PathAddress subsystemAddress = rootAddress.append(new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"infinispan")});
                    try {
                        infinispanResource = context.readResourceFromRoot(subsystemAddress);
                    }
                    catch (Resource.NoSuchResourceException ex) {
                        return DiscardPolicy.REJECT_AND_WARN;
                    }
                    ModelNode infinispanModel = Resource.Tools.readModel((Resource)infinispanResource);
                    if (infinispanModel.hasDefined("cache-container")) {
                        for (ModelNode container : infinispanModel.get("cache-container").asList()) {
                            ModelNode subsystem;
                            String channel;
                            ModelNode transport;
                            ModelNode cacheContainer = container.get(0);
                            if (!cacheContainer.hasDefined("transport") || !((transport = cacheContainer.get("transport").get("jgroups")).hasDefined("channel") ? (channel = transport.get("channel").asString()).equals(channelName) : (subsystem = context.readResourceFromRoot(address.subAddress(0, address.size() - 1)).getModel()).hasDefined(JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL.getName()) && subsystem.get(JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_CHANNEL.getName()).asString().equals(channelName))) continue;
                            return DiscardPolicy.SILENT;
                        }
                    }
                    return DiscardPolicy.REJECT_AND_WARN;
                }
            };
            parent.addChildResource(WILDCARD_PATH, channelDiscardRejectPolicy);
        } else {
            ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
            if (JGroupsModel.VERSION_4_0_0.requiresTransformation(version)) {
                DiscardAttributeChecker.DefaultDiscardAttributeChecker discarder = new DiscardAttributeChecker.DefaultDiscardAttributeChecker(false, true){

                    protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                        return !attributeValue.isDefined() || attributeValue.equals(new ModelNode(address.getLastElement().getValue()));
                    }
                };
                ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)discarder, new AttributeDefinition[]{Attribute.CLUSTER.getDefinition()})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Attribute.CLUSTER.getDefinition()});
            }
            ProtocolRegistration.buildTransformation(version, builder);
        }
    }

    ChannelResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver(WILDCARD_PATH));
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    public void register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(Capability.class).addCapabilities(CLUSTERING_CAPABILITIES.values()).addAlias((org.jboss.as.clustering.controller.Attribute)DeprecatedAttribute.STATS_ENABLED, (org.jboss.as.clustering.controller.Attribute)Attribute.STATISTICS_ENABLED).addOperationTranslator(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode parentModel;
                if (!operation.hasDefined(Attribute.STACK.getName()) && (parentModel = context.readResourceFromRoot(context.getCurrentAddress().getParent()).getModel()).hasDefined(JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK.getName())) {
                    operation.get(Attribute.STACK.getName()).set(parentModel.get(JGroupsSubsystemResourceDefinition.Attribute.DEFAULT_STACK.getName()));
                }
            }
        }).addRuntimeResourceRegistration((OperationStepHandler)new ProtocolResourceRegistrationHandler());
        ChannelServiceHandler handler = new ChannelServiceHandler();
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register(registration);
        if (this.allowRuntimeOnlyRegistration) {
            new MetricHandler((MetricExecutor)new ChannelMetricExecutor(), ChannelMetric.class).register(registration);
        }
        new ForkResourceDefinition().register(registration);
    }

    static {
        EnumSet.allOf(ClusteringRequirement.class).forEach(requirement -> CLUSTERING_CAPABILITIES.put((ClusteringRequirement)requirement, (org.jboss.as.clustering.controller.Capability)new UnaryRequirementCapability((UnaryRequirement)requirement, new Requirement[0])));
    }

    public static enum DeprecatedAttribute implements org.jboss.as.clustering.controller.Attribute
    {
        STATS_ENABLED("stats-enabled", ModelType.BOOLEAN, JGroupsModel.VERSION_4_1_0);

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, JGroupsModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type, true).setDeprecated(deprecation.getVersion())).setStorageRuntime()).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    public static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        STACK("stack", ModelType.STRING, (CapabilityReferenceRecorder)new CapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.JCHANNEL_FACTORY, (UnaryRequirement)JGroupsRequirement.CHANNEL_FACTORY)),
        MODULE("module", ModelType.STRING, new ModelNode("org.wildfly.clustering.server"), (ParameterValidatorBuilder)new ModuleIdentifierValidatorBuilder()),
        CLUSTER("cluster", ModelType.STRING),
        STATISTICS_ENABLED("statistics-enabled", ModelType.BOOLEAN, new ModelNode(false));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = Attribute.createBuilder(name, type).build();
        }

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)Attribute.createBuilder(name, type).setDefaultValue(defaultValue)).build();
        }

        private Attribute(String name, ModelType type, ModelNode defaultValue, ParameterValidatorBuilder validator) {
            SimpleAttributeDefinitionBuilder builder = (SimpleAttributeDefinitionBuilder)Attribute.createBuilder(name, type).setDefaultValue(defaultValue);
            this.definition = ((SimpleAttributeDefinitionBuilder)builder.setValidator(validator.configure((AbstractAttributeDefinitionBuilder)builder).build())).build();
        }

        private Attribute(String name, ModelType type, CapabilityReferenceRecorder reference) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)Attribute.createBuilder(name, type).setAllowExpression(false)).setRequired(true)).setCapabilityReference(reference)).build();
        }

        private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type) {
            return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES});
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Capability implements CapabilityProvider
    {
        JCHANNEL((UnaryRequirement)JGroupsRequirement.CHANNEL),
        FORK_CHANNEL_FACTORY((UnaryRequirement)JGroupsRequirement.CHANNEL_FACTORY),
        JCHANNEL_FACTORY((UnaryRequirement)JGroupsRequirement.CHANNEL_SOURCE),
        JCHANNEL_MODULE((UnaryRequirement)JGroupsRequirement.CHANNEL_MODULE),
        JCHANNEL_CLUSTER((UnaryRequirement)JGroupsRequirement.CHANNEL_CLUSTER);

        private org.jboss.as.clustering.controller.Capability capability;

        private Capability(UnaryRequirement requirement) {
            this.capability = new UnaryRequirementCapability(requirement, new Requirement[0]);
        }

        public org.jboss.as.clustering.controller.Capability getCapability() {
            return this.capability;
        }
    }
}

