/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.CredentialSourceDependency;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.protocol.EncryptProtocol;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.protocols.EncryptBase;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

public class EncryptProtocolConfigurationBuilder<P extends EncryptBase>
extends ProtocolConfigurationBuilder<P> {
    private volatile ValueDependency<KeyStore> keyStore;
    private volatile ValueDependency<CredentialSource> credentialSource;
    private volatile String keyAlias;

    public EncryptProtocolConfigurationBuilder(PathAddress address) {
        super(address);
    }

    @Override
    public Builder<ProtocolConfiguration<P>> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String keyStore = EncryptProtocolResourceDefinition.Attribute.KEY_STORE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.keyStore = new InjectedValueDependency(CommonUnaryRequirement.KEY_STORE.getServiceName(context, keyStore), KeyStore.class);
        this.keyAlias = EncryptProtocolResourceDefinition.Attribute.KEY_ALIAS.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.credentialSource = new CredentialSourceDependency(context, model);
        return super.configure(context, model);
    }

    @Override
    public ServiceBuilder<ProtocolConfiguration<P>> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        Stream.of(this.keyStore, this.credentialSource).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    @Override
    public void accept(P protocol) {
        KeyStore store = (KeyStore)this.keyStore.getValue();
        String alias = this.keyAlias;
        try {
            if (!store.containsAlias(alias)) {
                throw JGroupsLogger.ROOT_LOGGER.keyEntryNotFound(alias);
            }
            PasswordCredential credential = (PasswordCredential)((CredentialSource)this.credentialSource.getValue()).getCredential(PasswordCredential.class);
            if (credential == null) {
                throw JGroupsLogger.ROOT_LOGGER.unexpectedCredentialSource();
            }
            ClearPassword password = (ClearPassword)credential.getPassword(ClearPassword.class);
            if (password == null) {
                throw JGroupsLogger.ROOT_LOGGER.unexpectedCredentialSource();
            }
            ((EncryptProtocol)protocol).setKeyStore((KeyStore)this.keyStore.getValue());
            ((EncryptProtocol)protocol).setKeyAlias(this.keyAlias);
            ((EncryptProtocol)protocol).setKeyPassword(new KeyStore.PasswordProtection(password.getPassword()));
        }
        catch (IOException | KeyStoreException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

