/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jgroups.protocols.ASYM_ENCRYPT;
import org.jgroups.protocols.EncryptBase;
import org.jgroups.protocols.SYM_ENCRYPT;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.x500.cert.X509CertificateBuilder;

public class EncryptProtocolResourceDefinition<P extends EncryptBase>
extends ProtocolResourceDefinition<P> {
    private static final OperationStepHandler ADD_OPERATION_TRANSLATOR = new OperationStepHandler(){

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (!(operation.hasDefined(Attribute.KEY_STORE.getName()) || operation.hasDefined(Attribute.KEY_ALIAS.getName()) || operation.hasDefined(Attribute.CREDENTIAL.getName()))) {
                PathAddress subsystemAddress = context.getCurrentAddress().getParent();
                while (!subsystemAddress.getLastElement().getKey().equals("subsystem")) {
                    subsystemAddress = subsystemAddress.getParent();
                }
                Map<String, ModelNode> properties = ModelNodes.optionalPropertyList((ModelNode)AbstractProtocolResourceDefinition.Attribute.PROPERTIES.resolveModelAttribute((ExpressionResolver)context, operation)).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(Property::getName, Property::getValue));
                String keyStoreName = "jgroups-" + context.getCurrentAddress().getParent().getLastElement().getValue();
                LegacyEncryptDescriptor descriptor = LegacyEncryptDescriptorFactory.valueOf(context.getCurrentAddressValue()).apply(keyStoreName, properties);
                PathAddress keyStoreAddress = subsystemAddress.getParent().append(new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"elytron"), PathElement.pathElement((String)"key-store", (String)keyStoreName)});
                ModelNode keyStoreOperation = Util.createAddOperation((PathAddress)keyStoreAddress);
                keyStoreOperation.get("type").set(descriptor.getKeyStoreType());
                keyStoreOperation.get("path").set(descriptor.getKeyStorePath());
                keyStoreOperation.get("required").set(true);
                keyStoreOperation.get("credential-reference").get("clear-text").set(descriptor.getKeyStorePassword());
                OperationStepHandler addHandler = context.getRootResourceRegistration().getOperationHandler(keyStoreAddress, "add");
                if (addHandler == null) {
                    throw JGroupsLogger.ROOT_LOGGER.operationNotDefined("add", keyStoreAddress.toCLIStyleString());
                }
                context.addStep(keyStoreOperation, addHandler, OperationContext.Stage.MODEL);
                operation.get(Attribute.KEY_STORE.getName()).set(keyStoreName);
                operation.get(Attribute.KEY_ALIAS.getName()).set(descriptor.getKeyAlias());
                operation.get(Attribute.CREDENTIAL.getName()).get("clear-text").set(descriptor.getKeyPassword());
            }
        }
    };

    static void addTransformations(ModelVersion version, ResourceTransformationDescriptionBuilder builder) {
        ProtocolResourceDefinition.addTransformations(version, builder);
    }

    public EncryptProtocolResourceDefinition(String name, Consumer<ResourceDescriptor> descriptorConfigurator, ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        super(EncryptProtocolResourceDefinition.pathElement(name), descriptorConfigurator.andThen(descriptor -> descriptor.addAttributes(Attribute.class).addCapabilities(Capability.class).addOperationTranslator(ADD_OPERATION_TRANSLATOR)), address -> new EncryptProtocolConfigurationBuilder(address), parentBuilderFactory);
    }

    private static class LegacyAsymmetricEncryptDescriptor
    implements LegacyEncryptDescriptor {
        private static final ASYM_ENCRYPT DEFAULTS = new ASYM_ENCRYPT();
        private static final char[] PASSWORD_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
        private final SecureRandom random = new SecureRandom();
        private final char[] keyStorePassword = this.generatePassword(32);
        private final char[] keyPassword = this.generatePassword(32);
        private final String keyStoreType = KeyStore.getDefaultType();
        private final String alias;
        private final String path;

        LegacyAsymmetricEncryptDescriptor(String keyStoreName, Map<String, ModelNode> properties) throws OperationFailedException {
            String provider = Optional.ofNullable(properties.get("provider")).map(ModelNode::asString).orElse(null);
            String transformation = Optional.ofNullable(properties.get("asym_algorithm")).map(ModelNode::asString).orElse(DEFAULTS.asymAlgorithm());
            int index = transformation.indexOf(47);
            String algorithm = index < 0 ? transformation : transformation.substring(0, index);
            int keyLength = Optional.ofNullable(properties.get("asym_keylength")).map(ModelNode::asInt).orElse(DEFAULTS.asymKeylength());
            this.alias = DEFAULTS.getClass().getSimpleName();
            this.path = keyStoreName + ".keystore";
            try {
                KeyPairGenerator generator = provider != null ? KeyPairGenerator.getInstance(algorithm, provider) : KeyPairGenerator.getInstance(algorithm);
                generator.initialize(keyLength, this.random);
                KeyPair pair = generator.generateKeyPair();
                PrivilegedAction<String> action = () -> System.getProperty("user.name");
                X500Principal issuer = new X500Principal("UID=" + (String)WildFlySecurityManager.doUnchecked(action));
                X509Certificate certificate = new X509CertificateBuilder().setPublicKey(pair.getPublic()).setSignatureAlgorithmName("SHA1with" + algorithm).setSigningKey(pair.getPrivate()).setIssuerDn(issuer).setSubjectDn(issuer).build();
                KeyStore store = KeyStore.getInstance(this.keyStoreType);
                store.load(null, this.keyStorePassword);
                store.setKeyEntry(this.alias, pair.getPrivate(), this.keyPassword, new Certificate[]{certificate});
                store.store(new FileOutputStream(this.path), this.keyStorePassword);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }

        private char[] generatePassword(int length) {
            char[] password = new char[length];
            for (int i = 0; i < password.length; ++i) {
                password[i] = PASSWORD_ALPHABET[this.random.nextInt(PASSWORD_ALPHABET.length)];
            }
            return password;
        }

        @Override
        public ModelNode getKeyStoreType() {
            return new ModelNode(this.keyStoreType);
        }

        @Override
        public ModelNode getKeyStorePath() {
            return new ModelNode(this.path);
        }

        @Override
        public ModelNode getKeyStorePassword() {
            return new ModelNode(String.valueOf(this.keyStorePassword));
        }

        @Override
        public ModelNode getKeyAlias() {
            return new ModelNode(this.alias);
        }

        @Override
        public ModelNode getKeyPassword() {
            return new ModelNode(String.valueOf(this.keyPassword));
        }
    }

    private static class LegacySymmetricEncryptDescriptor
    implements LegacyEncryptDescriptor {
        private static final SYM_ENCRYPT DEFAULTS = new SYM_ENCRYPT();
        private final Map<String, ModelNode> properties;

        LegacySymmetricEncryptDescriptor(Map<String, ModelNode> properties) {
            this.properties = properties;
        }

        @Override
        public ModelNode getKeyStoreType() {
            return this.properties.getOrDefault("keystore_type", new ModelNode("JCEKS"));
        }

        @Override
        public ModelNode getKeyStorePath() {
            return this.properties.get("keystore_name");
        }

        @Override
        public ModelNode getKeyStorePassword() {
            return this.properties.getOrDefault("store_password", new ModelNode(DEFAULTS.storePassword()));
        }

        @Override
        public ModelNode getKeyAlias() {
            return this.properties.getOrDefault("alias", new ModelNode(DEFAULTS.alias()));
        }

        @Override
        public ModelNode getKeyPassword() {
            return this.properties.getOrDefault("key_password", this.getKeyStorePassword());
        }
    }

    private static enum LegacyEncryptDescriptorFactory implements ExceptionBiFunction<String, Map<String, ModelNode>, LegacyEncryptDescriptor, OperationFailedException>
    {
        ASYM_ENCRYPT((ExceptionBiFunction<String, Map<String, ModelNode>, LegacyEncryptDescriptor, OperationFailedException>)((ExceptionBiFunction)(keyStoreName, properties) -> new LegacyAsymmetricEncryptDescriptor((String)keyStoreName, (Map<String, ModelNode>)properties))),
        SYM_ENCRYPT((ExceptionBiFunction<String, Map<String, ModelNode>, LegacyEncryptDescriptor, OperationFailedException>)((ExceptionBiFunction)(keyStoreName, properties) -> new LegacySymmetricEncryptDescriptor((Map<String, ModelNode>)properties)));

        private final ExceptionBiFunction<String, Map<String, ModelNode>, LegacyEncryptDescriptor, OperationFailedException> factory;

        private LegacyEncryptDescriptorFactory(ExceptionBiFunction<String, Map<String, ModelNode>, LegacyEncryptDescriptor, OperationFailedException> factory) {
            this.factory = factory;
        }

        public LegacyEncryptDescriptor apply(String keyStoreName, Map<String, ModelNode> properties) throws OperationFailedException {
            return (LegacyEncryptDescriptor)this.factory.apply((Object)keyStoreName, properties);
        }
    }

    private static interface LegacyEncryptDescriptor {
        public ModelNode getKeyStoreType();

        public ModelNode getKeyStorePath();

        public ModelNode getKeyStorePassword();

        public ModelNode getKeyAlias();

        public ModelNode getKeyPassword();
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        CREDENTIAL((AttributeDefinition)((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((String)"credential-reference", (String)"credential-reference", (boolean)false).setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.ENCRYPT_CREDENTIAL_STORE, (UnaryRequirement)CommonUnaryRequirement.CREDENTIAL_STORE))).build()),
        KEY_ALIAS("key-alias", ModelType.STRING, builder -> (SimpleAttributeDefinitionBuilder)builder.setAllowExpression(true)),
        KEY_STORE("key-store", ModelType.STRING, builder -> (SimpleAttributeDefinitionBuilder)builder.setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.ENCRYPT_KEY_STORE, (UnaryRequirement)CommonUnaryRequirement.KEY_STORE)));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, UnaryOperator<SimpleAttributeDefinitionBuilder> configurator) {
            this.definition = ((SimpleAttributeDefinitionBuilder)configurator.apply((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(true))).build();
        }

        private Attribute(AttributeDefinition definition) {
            this.definition = definition;
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Capability implements org.jboss.as.clustering.controller.Capability
    {
        ENCRYPT_CREDENTIAL_STORE("org.wildfly.extension.undertow.application-security-domain.single-sign-on.credential-store"),
        ENCRYPT_KEY_STORE("org.wildfly.extension.undertow.application-security-domain.single-sign-on.key-store");

        private final RuntimeCapability<Void> definition;

        private Capability(String name) {
            this.definition = RuntimeCapability.Builder.of((String)name, (boolean)true).build();
        }

        public RuntimeCapability<Void> getDefinition() {
            return this.definition;
        }

        public RuntimeCapability<?> resolve(PathAddress address) {
            return this.definition.fromBaseCapability(address.getParent().getLastElement().getValue());
        }
    }
}

