/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteServiceNameProvider;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.jgroups.spi.RemoteSiteConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;

public class RemoteSiteConfigurationBuilder
implements ResourceServiceBuilder<RemoteSiteConfiguration>,
RemoteSiteConfiguration {
    private final ServiceNameProvider provider;
    private final String siteName;
    private volatile ValueDependency<String> cluster;
    private volatile ValueDependency<ChannelFactory> factory;

    public RemoteSiteConfigurationBuilder(PathAddress address) {
        this.provider = new RemoteSiteServiceNameProvider(address);
        this.siteName = address.getLastElement().getValue();
    }

    public ServiceName getServiceName() {
        return this.provider.getServiceName();
    }

    public ServiceBuilder<RemoteSiteConfiguration> build(ServiceTarget target) {
        ImmediateValue value = new ImmediateValue((Object)this);
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)value)).setInitialMode(ServiceController.Mode.ON_DEMAND);
        return new CompositeDependency(new Dependency[]{this.cluster, this.factory}).register(builder);
    }

    public Builder<RemoteSiteConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String channel = RemoteSiteResourceDefinition.Attribute.CHANNEL.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.cluster = new InjectedValueDependency(JGroupsRequirement.CHANNEL_CLUSTER.getServiceName(context, channel), String.class);
        this.factory = new InjectedValueDependency(JGroupsRequirement.CHANNEL_SOURCE.getServiceName(context, channel), ChannelFactory.class);
        return this;
    }

    public String getName() {
        return this.siteName;
    }

    public ChannelFactory getChannelFactory() {
        return (ChannelFactory)this.factory.getValue();
    }

    public String getClusterName() {
        return (String)this.cluster.getValue();
    }
}

