/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.SocketDiscoveryProtocolResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.jgroups.protocols.Discovery;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SocketDiscoveryProtocolConfigurationBuilder<A, P extends Discovery>
extends ProtocolConfigurationBuilder<P> {
    private final Function<InetSocketAddress, A> hostTransformer;
    private final List<ValueDependency<OutboundSocketBinding>> bindings = new LinkedList<ValueDependency<OutboundSocketBinding>>();

    public SocketDiscoveryProtocolConfigurationBuilder(PathAddress address, Function<InetSocketAddress, A> hostTransformer) {
        super(address);
        this.hostTransformer = hostTransformer;
    }

    @Override
    public Builder<ProtocolConfiguration<P>> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.bindings.clear();
        for (String binding : StringListAttributeDefinition.unwrapValue((ExpressionResolver)context, (ModelNode)SocketDiscoveryProtocolResourceDefinition.Attribute.OUTBOUND_SOCKET_BINDINGS.resolveModelAttribute((ExpressionResolver)context, model))) {
            this.bindings.add((ValueDependency<OutboundSocketBinding>)new InjectedValueDependency(CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING.getServiceName(context, binding), OutboundSocketBinding.class));
        }
        return super.configure(context, model);
    }

    @Override
    public ServiceBuilder<ProtocolConfiguration<P>> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        for (Dependency dependency : this.bindings) {
            dependency.register(builder);
        }
        return builder;
    }

    @Override
    public void accept(P protocol) {
        if (!this.bindings.isEmpty()) {
            ArrayList<A> initialHosts = new ArrayList<A>(this.bindings.size());
            for (Value value : this.bindings) {
                OutboundSocketBinding binding = (OutboundSocketBinding)value.getValue();
                try {
                    initialHosts.add(this.hostTransformer.apply(new InetSocketAddress(binding.getResolvedDestinationAddress(), binding.getDestinationPort())));
                }
                catch (UnknownHostException e) {
                    throw JGroupsLogger.ROOT_LOGGER.failedToResolveSocketBinding(e, binding);
                }
            }
            PrivilegedAction<Protocol> action = () -> protocol.setValue("initial_hosts", (Object)initialHosts);
            WildFlySecurityManager.doUnchecked(action);
        }
    }
}

