/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jgroups.util.Util;

public interface SocketFactory
extends org.jgroups.util.SocketFactory {
    public static final int DEFAULT_BACKLOG = 0;
    public static final int DEFAULT_BIND_PORT = 0;

    default public Socket createSocket(String name, String host, int port) throws IOException {
        return this.createSocket(name, new InetSocketAddress(host, port), null);
    }

    default public Socket createSocket(String name, InetAddress address, int port) throws IOException {
        return this.createSocket(name, new InetSocketAddress(address, port), null);
    }

    default public Socket createSocket(String name, String host, int port, InetAddress bindAddress, int bindPort) throws IOException {
        return this.createSocket(name, new InetSocketAddress(host, port), new InetSocketAddress(bindAddress, bindPort));
    }

    default public Socket createSocket(String name, InetAddress address, int port, InetAddress bindAddress, int bindPort) throws IOException {
        return this.createSocket(name, new InetSocketAddress(address, port), new InetSocketAddress(bindAddress, bindPort));
    }

    default public Socket createSocket(String name, SocketAddress connectAddress, SocketAddress bindAddress) throws IOException {
        Socket socket = this.createSocket(name);
        try {
            if (bindAddress != null) {
                socket.bind(bindAddress);
            }
            socket.connect(connectAddress);
        }
        catch (IOException e) {
            this.close(socket);
            throw e;
        }
        return socket;
    }

    default public ServerSocket createServerSocket(String name, int port) throws IOException {
        return this.createServerSocket(name, port, 0);
    }

    default public ServerSocket createServerSocket(String name, int port, int backlog) throws IOException {
        return this.createServerSocket(name, new InetSocketAddress(port), backlog);
    }

    default public ServerSocket createServerSocket(String name, int port, int backlog, InetAddress address) throws IOException {
        return this.createServerSocket(name, new InetSocketAddress(address, port), backlog);
    }

    default public ServerSocket createServerSocket(String name, SocketAddress bindAddress, int backlog) throws IOException {
        ServerSocket socket = this.createServerSocket(name);
        try {
            socket.bind(bindAddress, backlog);
        }
        catch (IOException e) {
            this.close(socket);
            throw e;
        }
        return socket;
    }

    default public SocketChannel createSocketChannel(String name, SocketAddress bindAddress) throws IOException {
        SocketChannel channel = this.createSocketChannel(name);
        try {
            channel.bind(bindAddress);
        }
        catch (IOException e) {
            this.close(channel);
            throw e;
        }
        return channel;
    }

    default public ServerSocketChannel createServerSocketChannel(String name, int port) throws IOException {
        return this.createServerSocketChannel(name, port, 0);
    }

    default public ServerSocketChannel createServerSocketChannel(String name, int port, int backlog) throws IOException {
        return this.createServerSocketChannel(name, new InetSocketAddress(port), backlog);
    }

    default public ServerSocketChannel createServerSocketChannel(String name, int port, int backlog, InetAddress address) throws IOException {
        return this.createServerSocketChannel(name, new InetSocketAddress(address, port), backlog);
    }

    default public ServerSocketChannel createServerSocketChannel(String name, SocketAddress bindAddress, int backlog) throws IOException {
        ServerSocketChannel channel = this.createServerSocketChannel(name);
        try {
            channel.bind(bindAddress, backlog);
        }
        catch (IOException e) {
            this.close(channel);
            throw e;
        }
        return channel;
    }

    default public DatagramSocket createDatagramSocket(String name) throws SocketException {
        return this.createDatagramSocket(name, 0);
    }

    default public DatagramSocket createDatagramSocket(String name, int port) throws SocketException {
        return this.createDatagramSocket(name, new InetSocketAddress(port));
    }

    default public DatagramSocket createDatagramSocket(String name, int port, InetAddress address) throws SocketException {
        return this.createDatagramSocket(name, new InetSocketAddress(address, port));
    }

    default public MulticastSocket createMulticastSocket(String name) throws IOException {
        return this.createMulticastSocket(name, 0);
    }

    default public MulticastSocket createMulticastSocket(String name, int port) throws IOException {
        return this.createMulticastSocket(name, new InetSocketAddress(port));
    }

    default public MulticastSocket createMulticastSocket(String name, int port, InetAddress address) throws IOException {
        return this.createMulticastSocket(name, new InetSocketAddress(address, port));
    }

    default public void close(Socket socket) throws IOException {
        Util.close((Closeable)socket);
    }

    default public void close(ServerSocket socket) throws IOException {
        Util.close((Closeable)socket);
    }

    default public void close(DatagramSocket socket) {
        Util.close((Closeable)socket);
    }
}

