/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.jgroups.auth.BinaryAuthToken;
import org.jboss.as.clustering.jgroups.auth.CipherAuthToken;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.AuthTokenResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.CipherAuthTokenResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.DigestAuthTokenResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.PlainAuthTokenResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jgroups.auth.AuthToken;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.AUTH;
import org.wildfly.clustering.jgroups.spi.ChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.service.Dependency;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.ResourceCapabilityReference;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ServiceDependency;

public class AuthProtocolResourceDefinitionRegistrar
extends AbstractProtocolResourceDefinitionRegistrar<AUTH> {
    private static final ResourceCapabilityReference<AuthToken> TOKEN;

    AuthProtocolResourceDefinitionRegistrar(final Protocol registration, final ResourceOperationRuntimeHandler parentRuntimeHandler) {
        super(new AbstractProtocolResourceDefinitionRegistrar.Configurator(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return registration;
            }

            @Override
            public ResourceOperationRuntimeHandler getParentRuntimeHandler() {
                return parentRuntimeHandler;
            }
        });
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).addResourceCapabilityReference(TOKEN)).withOperationTransformation("add", (UnaryOperator)new AbstractProtocolResourceDefinitionRegistrar.LegacyAddOperationTransformation("auth_class"))).withOperationTransformation(Set.of("remove", MapOperations.MAP_GET_DEFINITION.getName(), MapOperations.MAP_PUT_DEFINITION.getName(), MapOperations.MAP_REMOVE_DEFINITION.getName(), MapOperations.MAP_CLEAR_DEFINITION.getName()), LEGACY_OPERATION_TRANSFORMER);
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = super.register(parent, context);
        new PlainAuthTokenResourceDefinitionRegistrar().register(registration, context);
        new DigestAuthTokenResourceDefinitionRegistrar().register(registration, context);
        new CipherAuthTokenResourceDefinitionRegistrar().register(registration, context);
        return registration;
    }

    @Override
    public ServiceDependency<ProtocolConfiguration<AUTH>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        return super.resolve(context, model).combine((Dependency)TOKEN.resolve(context, model), (BiFunction)new BiFunction<ProtocolConfiguration<AUTH>, AuthToken, ProtocolConfiguration<AUTH>>(){

            @Override
            public ProtocolConfiguration<AUTH> apply(ProtocolConfiguration<AUTH> config, final AuthToken token) {
                return new ProtocolConfigurationResourceDefinitionRegistrar.ProtocolConfigurationDecorator<AUTH>(config){

                    @Override
                    public AUTH createProtocol(ChannelFactoryConfiguration configuration) {
                        return ((AUTH)super.createProtocol(configuration)).setAuthToken(token);
                    }
                };
            }
        });
    }

    static {
        ClassConfigurator.add((short)1100, BinaryAuthToken.class);
        ClassConfigurator.add((short)1101, CipherAuthToken.class);
        TOKEN = ResourceCapabilityReference.builder(AbstractProtocolResourceDefinitionRegistrar.CAPABILITY, AuthTokenResourceDefinitionRegistrar.SERVICE_DESCRIPTOR).build();
    }

    static enum Protocol implements ResourceRegistration
    {
        AUTH;

        private final PathElement path = StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement("AUTH");

        public PathElement getPathElement() {
            return this.path;
        }
    }
}

