/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    CHANNEL("channel"),
    CLUSTER("cluster"),
    DEFAULT_EXECUTOR("default-executor"),
    DEFAULT("default"),
    DEFAULT_STACK("default-stack"),
    DIAGNOSTICS_SOCKET_BINDING("diagnostics-socket-binding"),
    KEEPALIVE_TIME("keepalive-time"),
    MACHINE("machine"),
    MAX_THREADS("max-threads"),
    MIN_THREADS("min-threads"),
    MODULE("module"),
    NAME("name"),
    NAMESPACE("xmlns"),
    OOB_EXECUTOR("oob-executor"),
    QUEUE_LENGTH("queue-length"),
    RACK("rack"),
    SHARED("shared"),
    SITE("site"),
    SOCKET_BINDING("socket-binding"),
    STACK("stack"),
    THREAD_FACTORY("thread-factory"),
    TIMER_EXECUTOR("timer-executor"),
    TYPE("type");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute != null ? attribute : UNKNOWN;
    }

    static {
        attributes = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            attributes.put(name, attribute);
        }
    }
}

