/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.jgroups.JGroupsMessages;
import org.jboss.as.clustering.jgroups.subsystem.ChannelInstanceResource;
import org.jboss.as.clustering.jgroups.subsystem.ChannelInstanceResourceDefinition;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jgroups.JChannel;

public class ChannelMetricsHandler
extends AbstractRuntimeOnlyHandler {
    public static final ChannelMetricsHandler INSTANCE = new ChannelMetricsHandler();

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String channelName = pathAddress.getElement(pathAddress.size() - 1).getValue();
        String attrName = operation.require("name").asString();
        ChannelMetrics metric = ChannelMetrics.getStat(attrName);
        ServiceName channelServiceName = ChannelInstanceResource.CHANNEL_PARENT.append(new String[]{channelName});
        ServiceController controller = context.getServiceRegistry(false).getService(channelServiceName);
        boolean started = controller != null && controller.getValue() != null;
        ModelNode result = new ModelNode();
        if (metric == null) {
            context.getFailureDescription().set(JGroupsMessages.MESSAGES.unknownMetric(attrName));
        } else if (started) {
            JChannel channel = (JChannel)controller.getValue();
            switch (metric) {
                case ADDRESS: {
                    result.set(channel.getAddressAsString());
                    break;
                }
                case ADDRESS_AS_UUID: {
                    result.set(channel.getAddressAsUUID());
                    break;
                }
                case DISCARD_OWN_MESSAGES: {
                    result.set(channel.getDiscardOwnMessages());
                    break;
                }
                case NUM_TASKS_IN_TIMER: {
                    result.set(channel.getNumberOfTasksInTimer());
                    break;
                }
                case NUM_TIMER_THREADS: {
                    result.set(channel.getTimerThreads());
                    break;
                }
                case RECEIVED_BYTES: {
                    result.set(channel.getReceivedBytes());
                    break;
                }
                case RECEIVED_MESSAGES: {
                    result.set(channel.getReceivedMessages());
                    break;
                }
                case SENT_BYTES: {
                    result.set(channel.getSentBytes());
                    break;
                }
                case SENT_MESSAGES: {
                    result.set(channel.getSentMessages());
                    break;
                }
                case STATE: {
                    result.set(channel.getState());
                    break;
                }
                case STATS_ENABLED: {
                    result.set(channel.statsEnabled());
                    break;
                }
                case VERSION: {
                    result.set(JChannel.getVersion());
                    break;
                }
                case VIEW: {
                    result.set(channel.getViewAsString());
                }
            }
            context.getResult().set(result);
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }

    public static enum ChannelMetrics {
        ADDRESS((AttributeDefinition)ChannelInstanceResourceDefinition.ADDRESS),
        ADDRESS_AS_UUID((AttributeDefinition)ChannelInstanceResourceDefinition.ADDRESS_AS_UUID),
        DISCARD_OWN_MESSAGES((AttributeDefinition)ChannelInstanceResourceDefinition.DISCARD_OWN_MESSAGES),
        NUM_TASKS_IN_TIMER((AttributeDefinition)ChannelInstanceResourceDefinition.NUM_TASKS_IN_TIMER),
        NUM_TIMER_THREADS((AttributeDefinition)ChannelInstanceResourceDefinition.NUM_TIMER_THREADS),
        RECEIVED_BYTES((AttributeDefinition)ChannelInstanceResourceDefinition.RECEIVED_BYTES),
        RECEIVED_MESSAGES((AttributeDefinition)ChannelInstanceResourceDefinition.RECEIVED_MESSAGES),
        SENT_BYTES((AttributeDefinition)ChannelInstanceResourceDefinition.SENT_BYTES),
        SENT_MESSAGES((AttributeDefinition)ChannelInstanceResourceDefinition.SENT_MESSAGES),
        STATE((AttributeDefinition)ChannelInstanceResourceDefinition.STATE),
        STATS_ENABLED((AttributeDefinition)ChannelInstanceResourceDefinition.STATS_ENABLED),
        VERSION((AttributeDefinition)ChannelInstanceResourceDefinition.VERSION),
        VIEW((AttributeDefinition)ChannelInstanceResourceDefinition.VIEW);

        private static final Map<String, ChannelMetrics> MAP;
        final AttributeDefinition definition;

        private ChannelMetrics(AttributeDefinition definition) {
            this.definition = definition;
        }

        public String toString() {
            return this.definition.getName();
        }

        public static ChannelMetrics getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, ChannelMetrics>();
            for (ChannelMetrics metric : ChannelMetrics.values()) {
                MAP.put(metric.toString(), metric);
            }
        }
    }
}

