/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.AnyMarshaller;
import org.wildfly.clustering.marshalling.protostream.MarshallerProvider;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferInputStream;
import org.wildfly.clustering.marshalling.spi.ByteBufferOutputStream;

public enum ObjectMarshaller implements MarshallerProvider
{
    INSTANCE;


    @Override
    public Class<? extends Object> getJavaClass() {
        return Object.class;
    }

    @Override
    public Object readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        try (ByteBufferInputStream input = new ByteBufferInputStream(reader.readByteBuffer());){
            Object object = ((Any)ProtobufUtil.readFrom((ImmutableSerializationContext)context, (InputStream)input, Any.class)).get();
            return object;
        }
    }

    @Override
    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
        try (ByteBufferOutputStream output = new ByteBufferOutputStream(this.size(context, value));){
            ProtobufUtil.writeTo((ImmutableSerializationContext)context, (OutputStream)output, (Object)new Any(value));
            ByteBuffer buffer = output.getBuffer();
            int offset = buffer.arrayOffset();
            int size = buffer.limit() - offset;
            writer.writeUInt32NoTag(size);
            writer.writeRawBytes(buffer.array(), offset, size);
        }
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, Object value) {
        AnyMarshaller marshaller = (AnyMarshaller)context.getMarshaller(Any.class);
        OptionalInt size = marshaller.size(context, new Any(value));
        return size.isPresent() ? OptionalInt.of(Predictable.byteArraySize(size.getAsInt())) : OptionalInt.empty();
    }

    @Override
    public ProtoStreamMarshaller<?> getMarshaller() {
        return this;
    }
}

