/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;

public class AbstractMarshallerProvider
implements SerializationContext.MarshallerProvider {
    private final Map<String, BaseMarshaller<?>> marshallerByName = new HashMap();
    private final Map<Class<?>, BaseMarshaller<?>> marshallerByType = new IdentityHashMap();

    public AbstractMarshallerProvider(BaseMarshaller<?> ... marshallers) {
        this(Arrays.asList(marshallers));
    }

    public AbstractMarshallerProvider(Iterable<? extends BaseMarshaller<?>> marshallers) {
        for (BaseMarshaller<?> marshaller : marshallers) {
            this.marshallerByName.put(marshaller.getTypeName(), marshaller);
            this.marshallerByType.put(marshaller.getJavaClass(), marshaller);
        }
    }

    public BaseMarshaller<?> getMarshaller(String typeName) {
        return this.marshallerByName.get(typeName);
    }

    public BaseMarshaller<?> getMarshaller(Class<?> javaClass) {
        Class<?> targetClass = javaClass;
        Class<?> superClass = javaClass.getSuperclass();
        while (!this.marshallerByType.containsKey(targetClass) && superClass != null && Modifier.isAbstract(superClass.getModifiers())) {
            targetClass = superClass;
            superClass = targetClass.getSuperclass();
        }
        return this.marshallerByType.get(targetClass);
    }
}

