/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.DataOutput;
import java.io.IOException;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.DefaultProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class ProtoStreamDataOutput
implements DataOutput {
    private final ProtoStreamWriter writer;

    public ProtoStreamDataOutput(ImmutableSerializationContext context, RawProtoStreamWriter writer) {
        this.writer = new DefaultProtoStreamWriter(context, writer);
    }

    public ProtoStreamDataOutput(ProtoStreamWriter writer) {
        this.writer = writer;
    }

    @Override
    public void write(int value) throws IOException {
        this.writeByte(value);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.writer.writeRawBytes(bytes, offset, length);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.writer.writeBoolNoTag(value);
    }

    @Override
    public void writeByte(int value) throws IOException {
        this.writer.writeUInt32NoTag((byte)value);
    }

    @Override
    public void writeShort(int value) throws IOException {
        this.writer.writeUInt32NoTag((short)value);
    }

    @Override
    public void writeChar(int value) throws IOException {
        this.writer.writeUInt32NoTag(value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.writer.writeSInt32NoTag(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.writer.writeSInt64NoTag(value);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.writer.writeFloatNoTag(value);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.writer.writeDoubleNoTag(value);
    }

    @Override
    public void writeBytes(String value) throws IOException {
        for (int i = 0; i < value.length(); ++i) {
            this.writeByte(value.charAt(i));
        }
    }

    @Override
    public void writeChars(String value) throws IOException {
        for (int i = 0; i < value.length(); ++i) {
            this.writeChar(value.charAt(i));
        }
    }

    @Override
    public void writeUTF(String value) throws IOException {
        this.writer.writeStringNoTag(value);
    }
}

