/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValueExternalizer;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;

public class ByteBufferMarshalledValue<T>
implements MarshalledValue<T, ByteBufferMarshaller>,
Serializable {
    private static final long serialVersionUID = -8419893544424515905L;
    private volatile transient ByteBufferMarshaller marshaller;
    private volatile transient T object;
    private volatile transient ByteBuffer buffer;

    public ByteBufferMarshalledValue(T object, ByteBufferMarshaller marshaller) {
        this.marshaller = marshaller;
        this.object = object;
    }

    ByteBufferMarshalledValue(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    T peek() {
        return this.object;
    }

    synchronized ByteBuffer getBuffer() throws IOException {
        ByteBuffer buffer = this.buffer;
        if (buffer != null) {
            return buffer;
        }
        if (this.object == null) {
            return null;
        }
        return this.marshaller.write(this.object);
    }

    @Override
    public synchronized T get(ByteBufferMarshaller marshaller) throws IOException {
        if (this.object == null) {
            this.marshaller = marshaller;
            if (this.buffer != null) {
                this.object = this.marshaller.read(this.buffer);
                this.buffer = null;
            }
        }
        return this.object;
    }

    public int hashCode() {
        T object = this.object;
        return object != null ? object.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ByteBufferMarshalledValue)) {
            return false;
        }
        ByteBufferMarshalledValue value = (ByteBufferMarshalledValue)object;
        T ourObject = this.object;
        T theirObject = value.object;
        if (ourObject != null && theirObject != null) {
            return ourObject.equals(theirObject);
        }
        try {
            ByteBuffer us = this.getBuffer();
            ByteBuffer them = value.getBuffer();
            return us != null && them != null ? us.equals(them) : us == them;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        T object = this.object;
        if (object != null) {
            return object.toString();
        }
        ByteBuffer buffer = this.buffer;
        return buffer != null ? buffer.toString() : null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ByteBufferMarshalledValueExternalizer.writeBuffer(out, this.getBuffer());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.buffer = ByteBufferMarshalledValueExternalizer.readBuffer(in);
    }
}

