/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.OptionalInt;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.Formatter;
import org.wildfly.clustering.marshalling.spi.SimpleFormatter;

public class StringExternalizer<T>
implements Externalizer<T> {
    private final Formatter<T> formatter;

    public StringExternalizer(Formatter<T> formatter) {
        this.formatter = formatter;
    }

    public StringExternalizer(Class<T> targetClass, Function<String, T> reader) {
        this.formatter = new SimpleFormatter<T>(targetClass, reader);
    }

    public StringExternalizer(Class<T> targetClass, Function<String, T> reader, Function<T, String> writer) {
        this.formatter = new SimpleFormatter<T>(targetClass, reader, writer);
    }

    public void writeObject(ObjectOutput output, T object) throws IOException {
        output.writeUTF(this.formatter.format(object));
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return this.formatter.parse(input.readUTF());
    }

    public OptionalInt size(T object) {
        return OptionalInt.of(this.formatter.format(object).length() + 1);
    }

    public Class<T> getTargetClass() {
        return this.formatter.getTargetClass();
    }
}

