/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.singleton.election;

import java.util.Arrays;
import java.util.List;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.election.Preference;

public class PreferredSingletonElectionPolicy
implements SingletonElectionPolicy {
    private final List<Preference> preferences;
    private final SingletonElectionPolicy policy;

    public PreferredSingletonElectionPolicy(SingletonElectionPolicy policy, Preference ... preferences) {
        this(policy, Arrays.asList(preferences));
    }

    public PreferredSingletonElectionPolicy(SingletonElectionPolicy policy, List<Preference> preferences) {
        this.policy = policy;
        this.preferences = preferences;
    }

    @Override
    public Node elect(List<Node> candidates) {
        for (Preference preference : this.preferences) {
            for (Node candidate : candidates) {
                if (!preference.preferred(candidate)) continue;
                return candidate;
            }
        }
        return this.policy.elect(candidates);
    }
}

