/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton.deployment;

import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.wildfly.extension.clustering.singleton.SingletonServiceNameFactory;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentConfiguration;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentProcessor;

public class SingletonDeploymentDependencyProcessor
implements DeploymentUnitProcessor {
    public static final AttachmentKey<SingletonDeploymentConfiguration> CONFIGURATION_KEY = AttachmentKey.create(SingletonDeploymentConfiguration.class);

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        SingletonDeploymentConfiguration config;
        DeploymentUnit unit = context.getDeploymentUnit();
        if (unit.getParent() == null && (config = (SingletonDeploymentConfiguration)unit.getAttachment(CONFIGURATION_KEY)) != null) {
            CapabilityServiceSupport support = (CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            context.addDependency(SingletonServiceNameFactory.SINGLETON_POLICY.getServiceName(support, config.getPolicy()), SingletonDeploymentProcessor.POLICY_KEY);
        }
    }
}

