/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.SubsystemResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllSchema;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.singleton.SingletonPolicy;
import org.wildfly.clustering.singleton.service.ServiceTargetFactory;
import org.wildfly.extension.clustering.singleton.SingletonExtension;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentDependencyProcessor;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentParsingProcessor;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentProcessor;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentSchema;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.SubsystemResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class SingletonSubsystemResourceDefinitionRegistrar
implements SubsystemResourceDefinitionRegistrar,
ResourceServiceConfigurator,
Consumer<DeploymentProcessorTarget> {
    static final SubsystemResourceRegistration REGISTRATION = SubsystemResourceRegistration.of((String)"singleton");
    static final ParentResourceDescriptionResolver RESOLVER = new SubsystemResourceDescriptionResolver(REGISTRATION.getName(), SingletonExtension.class);
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((NullaryServiceDescriptor)ServiceTargetFactory.DEFAULT_SERVICE_DESCRIPTOR).build();
    static final CapabilityReferenceAttributeDefinition<ServiceTargetFactory> DEFAULT_SERVICE_TARGET_FACTORY = new CapabilityReferenceAttributeDefinition.Builder("default", CapabilityReference.builder(CAPABILITY, (UnaryServiceDescriptor)ServiceTargetFactory.SERVICE_DESCRIPTOR).build()).build();

    public ManagementResourceRegistration register(SubsystemRegistration parent, ManagementResourceRegistrationContext context) {
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)RESOLVER).addCapability(CAPABILITY)).addAttributes(List.of(DEFAULT_SERVICE_TARGET_FACTORY))).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this))).withDeploymentChainContributor((Consumer)this)).build();
        ManagementResourceRegistration registration = parent.registerSubsystemModel(ResourceDefinition.builder((ResourceRegistration)REGISTRATION, (ResourceDescriptionResolver)RESOLVER).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        new SingletonPolicyResourceDefinitionRegistrar().register(registration, context);
        return registration;
    }

    @Override
    public void accept(DeploymentProcessorTarget target) {
        target.addDeploymentProcessor(REGISTRATION.getName(), Phase.STRUCTURE, 2588, JBossAllSchema.createDeploymentUnitProcessor(EnumSet.allOf(SingletonDeploymentSchema.class), SingletonDeploymentDependencyProcessor.CONFIGURATION_KEY));
        target.addDeploymentProcessor(REGISTRATION.getName(), Phase.PARSE, 19200, (DeploymentUnitProcessor)new SingletonDeploymentParsingProcessor());
        target.addDeploymentProcessor(REGISTRATION.getName(), Phase.DEPENDENCIES, 8960, (DeploymentUnitProcessor)new SingletonDeploymentDependencyProcessor());
        target.addDeploymentProcessor(REGISTRATION.getName(), Phase.CONFIGURE_MODULE, 1024, (DeploymentUnitProcessor)new SingletonDeploymentProcessor());
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(CAPABILITY, (ServiceDependency)DEFAULT_SERVICE_TARGET_FACTORY.resolve(context, model)).provides(ServiceNameFactory.resolveServiceName((NullaryServiceDescriptor)org.wildfly.clustering.singleton.service.SingletonPolicy.DEFAULT_SERVICE_DESCRIPTOR))).provides(ServiceNameFactory.resolveServiceName((NullaryServiceDescriptor)SingletonPolicy.DEFAULT_SERVICE_DESCRIPTOR))).build();
    }
}

