/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.wildfly.clustering.web.cache.session.FilteringHttpSession;
import org.wildfly.clustering.web.cache.session.ImmutableFilteringHttpSession;
import org.wildfly.clustering.web.cache.session.SessionBindingNotifier;
import org.wildfly.clustering.web.session.ImmutableSession;

public class ImmutableSessionBindingNotifier
implements SessionBindingNotifier {
    private final FilteringHttpSession session;

    public ImmutableSessionBindingNotifier(ImmutableSession session, ServletContext context) {
        this.session = new ImmutableFilteringHttpSession(session, context);
    }

    @Override
    public void unbound() {
        Map<String, HttpSessionBindingListener> listeners = this.session.getAttributes(HttpSessionBindingListener.class);
        if (!listeners.isEmpty()) {
            for (Map.Entry<String, HttpSessionBindingListener> entry : listeners.entrySet()) {
                HttpSessionBindingListener listener = entry.getValue();
                listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this.session, entry.getKey(), (Object)listener));
            }
        }
    }
}

