/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.AbstractMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSessionFactory;
import org.wildfly.clustering.web.cache.session.CompositeSession;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.cache.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;

public class CompositeSessionFactory<V, L>
extends CompositeImmutableSessionFactory<V, L>
implements SessionFactory<CompositeSessionMetaDataEntry<L>, V, L> {
    private final SessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> metaDataFactory;
    private final SessionAttributesFactory<V> attributesFactory;
    private final LocalContextFactory<L> localContextFactory;

    public CompositeSessionFactory(SessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> metaDataFactory, SessionAttributesFactory<V> attributesFactory, LocalContextFactory<L> localContextFactory) {
        super(metaDataFactory, attributesFactory);
        this.metaDataFactory = metaDataFactory;
        this.attributesFactory = attributesFactory;
        this.localContextFactory = localContextFactory;
    }

    public Map.Entry<CompositeSessionMetaDataEntry<L>, V> createValue(String id, Void context) {
        CompositeSessionMetaDataEntry metaDataValue = (CompositeSessionMetaDataEntry)this.metaDataFactory.createValue(id, context);
        if (metaDataValue == null) {
            return null;
        }
        Object attributesValue = this.attributesFactory.createValue(id, context);
        return new AbstractMap.SimpleImmutableEntry<CompositeSessionMetaDataEntry, Object>(metaDataValue, attributesValue);
    }

    @Override
    public Map.Entry<CompositeSessionMetaDataEntry<L>, V> findValue(String id) {
        CompositeSessionMetaDataEntry metaDataValue = (CompositeSessionMetaDataEntry)this.metaDataFactory.findValue(id);
        if (metaDataValue != null) {
            Object attributesValue = this.attributesFactory.findValue(id);
            if (attributesValue != null) {
                return new AbstractMap.SimpleImmutableEntry<CompositeSessionMetaDataEntry, Object>(metaDataValue, attributesValue);
            }
            this.metaDataFactory.purge(id);
        }
        return null;
    }

    @Override
    public Map.Entry<CompositeSessionMetaDataEntry<L>, V> tryValue(String id) {
        CompositeSessionMetaDataEntry metaDataValue = (CompositeSessionMetaDataEntry)this.metaDataFactory.tryValue(id);
        if (metaDataValue != null) {
            Object attributesValue = this.attributesFactory.tryValue(id);
            if (attributesValue != null) {
                return new AbstractMap.SimpleImmutableEntry<CompositeSessionMetaDataEntry, Object>(metaDataValue, attributesValue);
            }
            this.metaDataFactory.purge(id);
        }
        return null;
    }

    public boolean remove(String id) {
        if (this.metaDataFactory.remove(id)) {
            this.attributesFactory.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public SessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> getMetaDataFactory() {
        return this.metaDataFactory;
    }

    @Override
    public SessionAttributesFactory<V> getAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public Session<L> createSession(String id, Map.Entry<CompositeSessionMetaDataEntry<L>, V> entry, ServletContext context) {
        CompositeSessionMetaDataEntry<L> key = entry.getKey();
        InvalidatableSessionMetaData metaData = this.metaDataFactory.createSessionMetaData(id, key);
        SessionAttributes attributes = this.attributesFactory.createSessionAttributes(id, entry.getValue(), (ImmutableSessionMetaData)metaData, context);
        return new CompositeSession<L>(id, metaData, attributes, key.getLocalContext(), this.localContextFactory, this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, ImmutableSessionMetaData metaData, ImmutableSessionAttributes attributes) {
        return new CompositeImmutableSession(id, metaData, attributes);
    }
}

