/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.function.Consumer;
import org.wildfly.clustering.web.cache.logging.Logger;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionMetaData;

public class ValidSession<L>
implements Session<L> {
    private final Session<L> session;
    private final Consumer<ImmutableSession> closeTask;

    public ValidSession(Session<L> session, Consumer<ImmutableSession> closeTask) {
        this.session = session;
        this.closeTask = closeTask;
    }

    private void validate() {
        if (!this.session.isValid()) {
            throw Logger.ROOT_LOGGER.invalidSession(this.getId());
        }
    }

    public String getId() {
        return this.session.getId();
    }

    public boolean isValid() {
        return this.session.isValid();
    }

    public L getLocalContext() {
        this.validate();
        return (L)this.session.getLocalContext();
    }

    public SessionMetaData getMetaData() {
        this.validate();
        return this.session.getMetaData();
    }

    public SessionAttributes getAttributes() {
        this.validate();
        return this.session.getAttributes();
    }

    public void invalidate() {
        this.validate();
        this.session.invalidate();
    }

    public void close() {
        this.session.close();
        this.closeTask.accept((ImmutableSession)this.session);
    }
}

