/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.catalina.session;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.catalina.session.LocalSessionContext;
import org.wildfly.clustering.web.catalina.session.SessionFacade;
import org.wildfly.clustering.web.catalina.session.ThreadLocalRequestValve;
import org.wildfly.clustering.web.session.RoutingSupport;
import org.wildfly.clustering.web.session.SessionManager;

public class ManagerFacade
extends ManagerBase
implements Lifecycle,
RoutingSupport {
    private final SessionManager<LocalSessionContext> manager;
    private final ReplicationConfig config;
    private final LifecycleSupport support = new LifecycleSupport((Lifecycle)this);
    private volatile int rejectedSessions = 0;
    private volatile boolean started = false;

    public ManagerFacade(SessionManager<LocalSessionContext> manager, ReplicationConfig config) {
        this.manager = manager;
        this.config = config;
        if (this.config.getUseJK() == null) {
            this.config.setUseJK(Boolean.valueOf(true));
        }
    }

    public Map.Entry<String, String> parse(String id) {
        int index = id.indexOf(46);
        return index < 0 ? new AbstractMap.SimpleImmutableEntry<String, Object>(id, null) : new AbstractMap.SimpleImmutableEntry<String, String>(id.substring(0, index), id.substring(index + 1));
    }

    public String format(String sessionId, String routeId) {
        return routeId != null ? String.format("%s.%s", sessionId, routeId) : sessionId;
    }

    public String locate(String sessionId) {
        return this.manager.locate(sessionId);
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        Context context = (Context)this.container;
        this.manager.setDefaultMaxInactiveInterval((long)context.getSessionTimeout(), TimeUnit.MINUTES);
        this.manager.start();
        this.started = true;
    }

    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.manager.stop();
        this.started = false;
    }

    public int getMaxInactiveInterval() {
        return (int)this.manager.getDefaultMaxInactiveInterval(TimeUnit.SECONDS);
    }

    public void setMaxInactiveInterval(int interval) {
        this.manager.setDefaultMaxInactiveInterval((long)interval, TimeUnit.SECONDS);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.support.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.support.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.support.removeLifecycleListener(listener);
    }

    public void backgroundProcess() {
    }

    public int getRejectedSessions() {
        return this.rejectedSessions;
    }

    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedSessions = rejectedSessions;
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public void add(Session session) {
    }

    private String getSessionId(String requestedSesssionId) {
        return this.config.getUseJK() != false ? this.parse(requestedSesssionId).getKey() : requestedSesssionId;
    }

    private Session getSession(org.wildfly.clustering.web.session.Session<LocalSessionContext> session) {
        String id = session.getId();
        if (this.config.getUseJK().booleanValue()) {
            id = this.format(id, this.locate(id));
            ThreadLocalRequestValve.currentRequest().changeSessionId(id);
        }
        return new SessionFacade((Manager)this, session, id, this.manager.getBatcher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session findSession(String id) {
        Batcher batcher = this.manager.getBatcher();
        boolean started = batcher.startBatch();
        org.wildfly.clustering.web.session.Session session = null;
        try {
            session = this.manager.findSession(this.getSessionId(id));
            Session session2 = session != null ? this.getSession((org.wildfly.clustering.web.session.Session<LocalSessionContext>)session) : null;
            return session2;
        }
        finally {
            if (started && session == null) {
                batcher.endBatch(false);
            }
        }
    }

    public Session createSession(String sessionId, Random random) {
        String id = sessionId != null ? this.getSessionId(sessionId) : this.manager.createSessionId();
        Batcher batcher = this.manager.getBatcher();
        boolean started = batcher.startBatch();
        try {
            return this.getSession((org.wildfly.clustering.web.session.Session<LocalSessionContext>)this.manager.createSession(id));
        }
        catch (Error | RuntimeException e) {
            if (started) {
                batcher.endBatch(false);
            }
            throw e;
        }
    }

    public Session[] findSessions() {
        return new Session[0];
    }

    public void remove(Session session) {
    }

    public int getActiveSessions() {
        return this.manager.size();
    }

    public String listSessionIds() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionAttribute(String sessionId, String key) {
        Batcher batcher = this.manager.getBatcher();
        boolean started = batcher.startBatch();
        try {
            org.wildfly.clustering.web.session.Session session = this.manager.findSession(this.getSessionId(sessionId));
            if (session == null) {
                String string = null;
                return string;
            }
            Object attribute = session.getAttributes().getAttribute(key);
            String string = attribute != null ? attribute.toString() : null;
            return string;
        }
        finally {
            if (started) {
                batcher.endBatch(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getSession(String sessionId) {
        Batcher batcher = this.manager.getBatcher();
        boolean started = batcher.startBatch();
        try {
            org.wildfly.clustering.web.session.Session session = this.manager.findSession(this.getSessionId(sessionId));
            if (session == null) {
                HashMap hashMap = null;
                return hashMap;
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            for (String name : session.getAttributes().getAttributeNames()) {
                attributes.put(name, session.getAttributes().getAttribute(name));
            }
            HashMap<String, Object> hashMap = attributes;
            return hashMap;
        }
        finally {
            if (started) {
                batcher.endBatch(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireSession(String sessionId) {
        Batcher batcher = this.manager.getBatcher();
        boolean started = batcher.startBatch();
        try {
            org.wildfly.clustering.web.session.Session session = this.manager.findSession(this.getSessionId(sessionId));
            if (session != null) {
                session.invalidate();
            }
        }
        finally {
            if (started) {
                batcher.endBatch(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastAccessedTime(String sessionId) {
        Batcher batcher = this.manager.getBatcher();
        boolean started = batcher.startBatch();
        try {
            org.wildfly.clustering.web.session.Session session = this.manager.findSession(this.getSessionId(sessionId));
            if (session == null) {
                String string = null;
                return string;
            }
            String string = session.getMetaData().getLastAccessedTime().toString();
            return string;
        }
        finally {
            if (started) {
                batcher.endBatch(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCreationTime(String sessionId) {
        Batcher batcher = this.manager.getBatcher();
        boolean started = batcher.startBatch();
        try {
            org.wildfly.clustering.web.session.Session session = this.manager.findSession(this.getSessionId(sessionId));
            if (session == null) {
                String string = null;
                return string;
            }
            String string = session.getMetaData().getCreationTime().toString();
            return string;
        }
        finally {
            if (started) {
                batcher.endBatch(false);
            }
        }
    }
}

