/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.catalina.sso;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Set;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.wildfly.clustering.web.catalina.sso.LocalSSOContext;
import org.wildfly.clustering.web.catalina.sso.ManagerRegistry;
import org.wildfly.clustering.web.sso.AuthenticationType;
import org.wildfly.clustering.web.sso.Credentials;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.Sessions;
import org.wildfly.clustering.web.sso.WebApplication;

public class SingleSignOnEntryFacade
extends SingleSignOnEntry {
    private final SSO<LocalSSOContext> sso;
    private final ManagerRegistry managerRegistry;

    public SingleSignOnEntryFacade(SSO<LocalSSOContext> sso, ManagerRegistry managerRegistry) {
        this.sso = sso;
        this.managerRegistry = managerRegistry;
    }

    public String getAuthType() {
        return this.sso.getCredentials().getAuthenticationType().name();
    }

    public String getPassword() {
        return this.sso.getCredentials().getPassword();
    }

    public Principal getPrincipal() {
        return ((LocalSSOContext)this.sso.getLocalContext()).getPrincipal();
    }

    public String getUsername() {
        return this.sso.getCredentials().getUser();
    }

    public synchronized void addSession(SingleSignOn sso, Session session) {
        this.sso.getSessions().addSession(this.managerRegistry.getApplication(session.getManager()), session.getId());
    }

    public synchronized void removeSession(Session session) {
        this.sso.getSessions().removeSession(this.managerRegistry.getApplication(session.getManager()));
    }

    public synchronized Session[] findSessions() {
        Sessions sessions = this.sso.getSessions();
        Set applications = sessions.getApplications();
        ArrayList<Session> results = new ArrayList<Session>(applications.size());
        for (WebApplication application : applications) {
            String sessionId = sessions.getSession(application);
            Manager manager = this.managerRegistry.getManager(application);
            if (manager == null) continue;
            try {
                results.add(manager.findSession(sessionId));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return results.toArray(new Session[results.size()]);
    }

    public void updateCredentials(Principal principal, String authType, String username, String password) {
        ((LocalSSOContext)this.sso.getLocalContext()).setPrincipal(principal);
        Credentials credentials = this.sso.getCredentials();
        credentials.setAuthenticationType(AuthenticationType.valueOf((String)authType));
        credentials.setUser(username);
        credentials.setPassword(password);
    }
}

