/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.web.infinispan.routing.InfinispanRoutingConfiguration;
import org.wildfly.clustering.web.infinispan.routing.InfinispanRoutingProvider;
import org.wildfly.clustering.web.routing.RoutingProvider;
import org.wildfly.extension.clustering.web.InfinispanRoutingProviderResourceDefinition;
import org.wildfly.extension.clustering.web.RoutingProviderServiceConfigurator;

public class InfinispanRoutingProviderServiceConfigurator
extends RoutingProviderServiceConfigurator
implements InfinispanRoutingConfiguration {
    private volatile String containerName;
    private volatile String cacheName;

    public InfinispanRoutingProviderServiceConfigurator(PathAddress address) {
        super(address);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.containerName = InfinispanRoutingProviderResourceDefinition.Attribute.CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.cacheName = InfinispanRoutingProviderResourceDefinition.Attribute.CACHE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        return super.configure(context, model);
    }

    @Override
    public RoutingProvider get() {
        return new InfinispanRoutingProvider((InfinispanRoutingConfiguration)this);
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void accept(ConfigurationBuilder builder) {
    }
}

