/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocator;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocatorConfiguration;
import org.wildfly.clustering.web.session.RouteLocator;

public class InfinispanRouteLocatorServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
InfinispanRouteLocatorConfiguration,
Supplier<RouteLocator> {
    private final String containerName = "web";
    private final String serverName;
    private final String deploymentName;
    private volatile SupplierDependency<NodeFactory<Address>> factory;
    private volatile SupplierDependency<Registry<String, Void>> registry;
    private volatile SupplierDependency<Cache<String, ?>> cache;

    public InfinispanRouteLocatorServiceConfigurator(String serverName, String deploymentName) {
        super(ServiceName.JBOSS.append(new String[]{"clustering", "web", "locator", deploymentName}));
        this.serverName = serverName;
        this.deploymentName = deploymentName;
    }

    @Override
    public RouteLocator get() {
        return new InfinispanRouteLocator(this);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.factory = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.containerName, this.serverName));
        this.registry = new ServiceSupplierDependency(ClusteringCacheRequirement.REGISTRY.getServiceName(support, this.containerName, this.serverName));
        this.cache = new ServiceSupplierDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, this.containerName, this.deploymentName));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer locator = new CompositeDependency(new Dependency[]{this.factory, this.registry, this.cache}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(locator, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public Cache<String, ?> getCache() {
        return (Cache)this.cache.get();
    }

    @Override
    public Registry<String, Void> getRegistry() {
        return (Registry)this.registry.get();
    }

    @Override
    public NodeFactory<Address> getMemberFactory() {
        return (NodeFactory)this.factory.get();
    }
}

