/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryBuilderProvider;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerFactory;
import org.wildfly.extension.undertow.session.DistributableSessionManagerConfiguration;

public class DistributableSessionManagerFactoryBuilder
implements org.wildfly.extension.undertow.session.DistributableSessionManagerFactoryBuilder,
Value<io.undertow.servlet.api.SessionManagerFactory> {
    static final Map<ReplicationGranularity, SessionManagerConfiguration.SessionAttributePersistenceStrategy> strategies = new EnumMap<ReplicationGranularity, SessionManagerConfiguration.SessionAttributePersistenceStrategy>(ReplicationGranularity.class);
    private final SessionManagerFactoryBuilderProvider<Batch> provider;
    private final InjectedValue<SessionManagerFactory> factory = new InjectedValue();

    private static SessionManagerFactoryBuilderProvider<Batch> load() {
        Iterator<SessionManagerFactoryBuilderProvider> iterator = ServiceLoader.load(SessionManagerFactoryBuilderProvider.class, SessionManagerFactoryBuilderProvider.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            SessionManagerFactoryBuilderProvider provider = iterator.next();
            return provider;
        }
        return null;
    }

    public DistributableSessionManagerFactoryBuilder() {
        this(DistributableSessionManagerFactoryBuilder.load());
    }

    public DistributableSessionManagerFactoryBuilder(SessionManagerFactoryBuilderProvider<Batch> provider) {
        this.provider = provider;
    }

    public ServiceBuilder<io.undertow.servlet.api.SessionManagerFactory> build(ServiceTarget target, ServiceName name, final DistributableSessionManagerConfiguration config) {
        SessionManagerConfiguration configuration = new SessionManagerConfiguration(){

            public int getMaxActiveSessions() {
                return config.getMaxActiveSessions();
            }

            public SessionManagerConfiguration.SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return strategies.get(config.getGranularity());
            }

            public String getDeploymentName() {
                return config.getDeploymentName();
            }

            public Module getModule() {
                return config.getModule();
            }

            public String getCacheName() {
                return config.getCacheName();
            }
        };
        Builder builder = this.provider.getBuilder(configuration);
        builder.build(target).install();
        return target.addService(name, (Service)new ValueService((Value)this)).addDependency(builder.getServiceName(), SessionManagerFactory.class, this.factory).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public io.undertow.servlet.api.SessionManagerFactory getValue() {
        return new DistributableSessionManagerFactory((SessionManagerFactory<Batch>)((SessionManagerFactory)this.factory.getValue()));
    }

    static {
        strategies.put(ReplicationGranularity.SESSION, SessionManagerConfiguration.SessionAttributePersistenceStrategy.COARSE);
        strategies.put(ReplicationGranularity.ATTRIBUTE, SessionManagerConfiguration.SessionAttributePersistenceStrategy.FINE);
    }
}

