/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.function.Consumer;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SpecificationProvider;

public enum UndertowSpecificationProvider implements SpecificationProvider<HttpSession, ServletContext, HttpSessionActivationListener>
{
    INSTANCE;


    public HttpSession createHttpSession(final ImmutableSession session, final ServletContext context) {
        return new HttpSession(){

            public String getId() {
                return session.getId();
            }

            public ServletContext getServletContext() {
                return context;
            }

            public boolean isNew() {
                return session.getMetaData().isNew();
            }

            public long getCreationTime() {
                return session.getMetaData().getCreationTime().toEpochMilli();
            }

            public long getLastAccessedTime() {
                return session.getMetaData().getLastAccessStartTime().toEpochMilli();
            }

            public int getMaxInactiveInterval() {
                return (int)session.getMetaData().getTimeout().getSeconds();
            }

            public Enumeration<String> getAttributeNames() {
                return Collections.enumeration(session.getAttributes().getAttributeNames());
            }

            public Object getAttribute(String name) {
                return session.getAttributes().getAttribute(name);
            }

            public void setAttribute(String name, Object value) {
            }

            public void removeAttribute(String name) {
            }

            public void invalidate() {
            }

            public void setMaxInactiveInterval(int interval) {
            }

            public int hashCode() {
                return this.getId().hashCode();
            }

            public boolean equals(Object object) {
                if (!(object instanceof HttpSession)) {
                    return false;
                }
                return this.getId().equals(((HttpSession)object).getId());
            }

            public String toString() {
                return this.getId();
            }
        };
    }

    public Class<HttpSessionActivationListener> getHttpSessionActivationListenerClass() {
        return HttpSessionActivationListener.class;
    }

    public Consumer<HttpSession> prePassivateNotifier(final HttpSessionActivationListener listener) {
        return new Consumer<HttpSession>(){

            @Override
            public void accept(HttpSession session) {
                listener.sessionWillPassivate(new HttpSessionEvent(session));
            }
        };
    }

    public Consumer<HttpSession> postActivateNotifier(final HttpSessionActivationListener listener) {
        return new Consumer<HttpSession>(){

            @Override
            public void accept(HttpSession session) {
                listener.sessionDidActivate(new HttpSessionEvent(session));
            }
        };
    }

    public HttpSessionActivationListener createListener(final Consumer<HttpSession> prePassivate, final Consumer<HttpSession> postActivate) {
        return new HttpSessionActivationListener(){

            public void sessionWillPassivate(HttpSessionEvent event) {
                prePassivate.accept(event.getSession());
            }

            public void sessionDidActivate(HttpSessionEvent event) {
                postActivate.accept(event.getSession());
            }
        };
    }
}

