/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import java.util.Map;
import java.util.function.Supplier;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.undertow.session.AbstractSession;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class DetachedDistributableSession
extends AbstractSession {
    private final RecordableSessionManagerStatistics statistics;

    public DetachedDistributableSession(UndertowSessionManager manager, org.wildfly.clustering.session.Session<Map<String, Object>> session, RecordableSessionManagerStatistics statistics) {
        super(manager, (Supplier<org.wildfly.clustering.session.Session<Map<String, Object>>>)org.wildfly.clustering.function.Supplier.of(session));
        this.statistics = statistics;
    }

    @Override
    public void invalidate(HttpServerExchange exchange) {
        org.wildfly.clustering.session.Session<Map<String, Object>> session = super.get();
        if (session.isValid()) {
            SessionListeners listeners = this.getSessionManager().getSessionListeners();
            listeners.sessionDestroyed((Session)this, exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
            for (Map.Entry attributesEntry : session.getAttributes().entrySet()) {
                listeners.attributeRemoved((Session)this, (String)attributesEntry.getKey(), attributesEntry.getValue());
            }
            if (this.statistics != null) {
                this.statistics.getInactiveSessionRecorder().record((ImmutableSessionMetaData)session.getMetaData());
            }
        }
        super.invalidate(exchange);
    }

    public void requestDone(HttpServerExchange serverExchange) {
    }

    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        return this.getId();
    }
}

