/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.core.ApplicationListeners;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.wildfly.clustering.web.session.SessionContext;

public class SessionContextAdapter
implements SessionContext {
    private final Deployment deployment;

    public SessionContextAdapter(Deployment deployment) {
        this.deployment = deployment;
    }

    public Iterable<HttpSessionListener> getSessionListeners() {
        final ApplicationListeners listeners = this.deployment.getApplicationListeners();
        HttpSessionListener listener = new HttpSessionListener(){

            public void sessionCreated(HttpSessionEvent event) {
                listeners.sessionCreated(event.getSession());
            }

            public void sessionDestroyed(HttpSessionEvent event) {
                listeners.sessionDestroyed(event.getSession());
            }
        };
        return Collections.singleton(listener);
    }

    public Iterable<HttpSessionAttributeListener> getSessionAttributeListeners() {
        final ApplicationListeners listeners = this.deployment.getApplicationListeners();
        HttpSessionAttributeListener listener = new HttpSessionAttributeListener(){

            public void attributeAdded(HttpSessionBindingEvent event) {
                listeners.httpSessionAttributeAdded(event.getSession(), event.getName(), event.getValue());
            }

            public void attributeRemoved(HttpSessionBindingEvent event) {
                listeners.httpSessionAttributeRemoved(event.getSession(), event.getName(), event.getValue());
            }

            public void attributeReplaced(HttpSessionBindingEvent event) {
                listeners.httpSessionAttributeReplaced(event.getSession(), event.getName(), event.getValue());
            }
        };
        return Collections.singleton(listener);
    }

    public ServletContext getServletContext() {
        return this.deployment.getServletContext();
    }
}

