/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;
import org.wildfly.extension.undertow.AbstractUndertowEventListener;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowService;

public class SessionManagerRegistryService
extends AbstractUndertowEventListener
implements Service<SessionManagerRegistry>,
SessionManagerRegistry {
    private final InjectedValue<UndertowService> service = new InjectedValue();
    private final InjectedValue<Host> host = new InjectedValue();
    private final ConcurrentMap<String, SessionManager> managers = new ConcurrentHashMap<String, SessionManager>();

    public static ServiceName getServiceName(ServiceName hostServiceName) {
        return hostServiceName.append(new String[]{"managers"});
    }

    public static ServiceBuilder<SessionManagerRegistry> build(ServiceTarget target, ServiceName hostServiceName) {
        SessionManagerRegistryService registry = new SessionManagerRegistryService();
        return target.addService(SessionManagerRegistryService.getServiceName(hostServiceName), (Service)registry).addDependency(UndertowService.UNDERTOW, UndertowService.class, registry.service).addDependency(hostServiceName, Host.class, registry.host);
    }

    private SessionManagerRegistryService() {
    }

    public SessionManagerRegistry getValue() {
        return this;
    }

    public void start(StartContext context) throws StartException {
        UndertowService service = (UndertowService)this.service.getValue();
        service.registerListener((UndertowEventListener)this);
        for (Deployment deployment : ((Host)this.host.getValue()).getDeployments()) {
            this.managers.putIfAbsent(deployment.getDeploymentInfo().getDeploymentName(), deployment.getSessionManager());
        }
    }

    public void stop(StopContext context) {
        ((UndertowService)this.service.getValue()).unregisterListener((UndertowEventListener)this);
        this.managers.clear();
    }

    public void onDeploymentStart(Deployment deployment, Host host) {
        if (((Host)this.host.getValue()).getName().equals(host.getName())) {
            this.managers.putIfAbsent(deployment.getDeploymentInfo().getDeploymentName(), deployment.getSessionManager());
        }
    }

    public void onDeploymentStop(Deployment deployment, Host host) {
        if (((Host)this.host.getValue()).getName().equals(host.getName())) {
            this.managers.remove(deployment.getDeploymentInfo().getDeploymentName());
        }
    }

    @Override
    public SessionManager getSessionManager(String deployment) {
        return (SessionManager)this.managers.get(deployment);
    }
}

