/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.ee.subsystem.ConcurrentAttribute;
import org.jboss.as.ee.subsystem.ConcurrentElement;
import org.jboss.as.ee.subsystem.ContextServiceResourceDefinition;
import org.jboss.as.ee.subsystem.ManagedExecutorServiceResourceDefinition;
import org.jboss.as.ee.subsystem.ManagedScheduledExecutorServiceResourceDefinition;
import org.jboss.as.ee.subsystem.ManagedThreadFactoryResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ConcurrentEESubsystemXMLPersister {
    private ConcurrentEESubsystemXMLPersister() {
    }

    public static void writeConcurrentElement(XMLExtendedStreamWriter writer, ModelNode eeSubSystem) throws XMLStreamException {
        boolean started = false;
        if (eeSubSystem.hasDefined("context-service")) {
            writer.writeStartElement(ConcurrentElement.CONCURRENT.getLocalName());
            started = true;
            ConcurrentEESubsystemXMLPersister.writeContextServices(writer, eeSubSystem.get("context-service"));
        }
        if (eeSubSystem.hasDefined("managed-thread-factory")) {
            if (!started) {
                writer.writeStartElement(ConcurrentElement.CONCURRENT.getLocalName());
                started = true;
            }
            ConcurrentEESubsystemXMLPersister.writeManagedThreadFactories(writer, eeSubSystem.get("managed-thread-factory"));
        }
        if (eeSubSystem.hasDefined("managed-executor-service")) {
            if (!started) {
                writer.writeStartElement(ConcurrentElement.CONCURRENT.getLocalName());
                started = true;
            }
            ConcurrentEESubsystemXMLPersister.writeManagedExecutorServices(writer, eeSubSystem.get("managed-executor-service"));
        }
        if (eeSubSystem.hasDefined("managed-scheduled-executor-service")) {
            if (!started) {
                writer.writeStartElement(ConcurrentElement.CONCURRENT.getLocalName());
                started = true;
            }
            ConcurrentEESubsystemXMLPersister.writeManagedScheduledExecutorServices(writer, eeSubSystem.get("managed-scheduled-executor-service"));
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private static void writeContextServices(XMLExtendedStreamWriter writer, ModelNode subModel) throws XMLStreamException {
        writer.writeStartElement(ConcurrentElement.CONTEXT_SERVICES.getLocalName());
        for (Property property : subModel.asPropertyList()) {
            writer.writeStartElement(ConcurrentElement.CONTEXT_SERVICE.getLocalName());
            writer.writeAttribute(ConcurrentAttribute.NAME.getLocalName(), property.getName());
            for (SimpleAttributeDefinition ad : ContextServiceResourceDefinition.ATTRIBUTES) {
                ad.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static void writeManagedThreadFactories(XMLExtendedStreamWriter writer, ModelNode subModel) throws XMLStreamException {
        writer.writeStartElement(ConcurrentElement.MANAGED_THREAD_FACTORIES.getLocalName());
        for (Property property : subModel.asPropertyList()) {
            writer.writeStartElement(ConcurrentElement.MANAGED_THREAD_FACTORY.getLocalName());
            writer.writeAttribute(ConcurrentAttribute.NAME.getLocalName(), property.getName());
            for (SimpleAttributeDefinition ad : ManagedThreadFactoryResourceDefinition.ATTRIBUTES) {
                ad.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static void writeManagedExecutorServices(XMLExtendedStreamWriter writer, ModelNode subModel) throws XMLStreamException {
        writer.writeStartElement(ConcurrentElement.MANAGED_EXECUTOR_SERVICES.getLocalName());
        for (Property property : subModel.asPropertyList()) {
            writer.writeStartElement(ConcurrentElement.MANAGED_EXECUTOR_SERVICE.getLocalName());
            writer.writeAttribute(ConcurrentAttribute.NAME.getLocalName(), property.getName());
            for (SimpleAttributeDefinition ad : ManagedExecutorServiceResourceDefinition.ATTRIBUTES) {
                ad.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static void writeManagedScheduledExecutorServices(XMLExtendedStreamWriter writer, ModelNode subModel) throws XMLStreamException {
        writer.writeStartElement(ConcurrentElement.MANAGED_SCHEDULED_EXECUTOR_SERVICES.getLocalName());
        for (Property property : subModel.asPropertyList()) {
            writer.writeStartElement(ConcurrentElement.MANAGED_SCHEDULED_EXECUTOR_SERVICE.getLocalName());
            writer.writeAttribute(ConcurrentAttribute.NAME.getLocalName(), property.getName());
            for (SimpleAttributeDefinition ad : ManagedScheduledExecutorServiceResourceDefinition.ATTRIBUTES) {
                ad.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

