/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.HashMap;
import java.util.Map;

enum ConcurrentAttribute {
    UNKNOWN(null),
    NAME("name"),
    JNDI_NAME("jndi-name"),
    USE_TRANSACTION_SETUP_PROVIDER("use-transaction-setup-provider"),
    CONTEXT_SERVICE("context-service"),
    PRIORITY("priority"),
    THREAD_FACTORY("thread-factory"),
    THREAD_PRIORITY("thread-priority"),
    HUNG_TASK_TERMINATION_PERIOD("hung-task-termination-period"),
    HUNG_TASK_THRESHOLD("hung-task-threshold"),
    LONG_RUNNING_TASKS("long-running-tasks"),
    CORE_THREADS("core-threads"),
    MAX_THREADS("max-threads"),
    KEEPALIVE_TIME("keepalive-time"),
    QUEUE_LENGTH("queue-length"),
    REJECT_POLICY("reject-policy");

    private final String name;
    private static final Map<String, ConcurrentAttribute> MAP;

    private ConcurrentAttribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static ConcurrentAttribute forName(String localName) {
        ConcurrentAttribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.getLocalName();
    }

    static {
        HashMap<String, ConcurrentAttribute> map = new HashMap<String, ConcurrentAttribute>();
        for (ConcurrentAttribute element : ConcurrentAttribute.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

