/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.List;
import org.jboss.as.connector._private.Capabilities;
import org.jboss.as.connector.subsystems.resourceadapters.AdminObjectResourceDefinition;
import org.jboss.as.connector.subsystems.resourceadapters.CommonAttributes;
import org.jboss.as.connector.subsystems.resourceadapters.ConfigPropertyAdd;
import org.jboss.as.connector.subsystems.resourceadapters.ConfigPropertyResourceDefinition;
import org.jboss.as.connector.subsystems.resourceadapters.ConnectionDefinitionResourceDefinition;
import org.jboss.as.connector.subsystems.resourceadapters.RaActivate;
import org.jboss.as.connector.subsystems.resourceadapters.RaAdd;
import org.jboss.as.connector.subsystems.resourceadapters.RaRemove;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersExtension;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;

public class ResourceAdapterResourceDefinition
extends SimpleResourceDefinition {
    private static final ResourceDescriptionResolver RESOLVER = ResourceAdaptersExtension.getResourceDescriptionResolver("resource-adapter");
    private static final OperationDefinition ACTIVATE_DEFINITION = new SimpleOperationDefinitionBuilder("activate", RESOLVER).build();
    private final boolean readOnly;
    private final boolean runtimeOnlyRegistrationValid;
    private final List<AccessConstraintDefinition> accessConstraints;

    public ResourceAdapterResourceDefinition(boolean readOnly, boolean runtimeOnlyRegistrationValid) {
        super(ResourceAdapterResourceDefinition.getParameters(readOnly));
        this.readOnly = readOnly;
        this.runtimeOnlyRegistrationValid = runtimeOnlyRegistrationValid;
        ApplicationTypeConfig atc = new ApplicationTypeConfig("resource-adapters", "resource-adapter");
        this.accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
    }

    private static SimpleResourceDefinition.Parameters getParameters(boolean readOnly) {
        SimpleResourceDefinition.Parameters parameters = new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"resource-adapter"), RESOLVER);
        if (!readOnly) {
            parameters.setAddHandler((OperationStepHandler)RaAdd.INSTANCE).setRemoveHandler((OperationStepHandler)RaRemove.INSTANCE).setCapabilities(new RuntimeCapability[]{Capabilities.RESOURCE_ADAPTER_CAPABILITY});
        }
        return parameters;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(ACTIVATE_DEFINITION, (OperationStepHandler)RaActivate.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attribute : CommonAttributes.RESOURCE_ADAPTER_ATTRIBUTE) {
            if (this.readOnly) {
                resourceRegistration.registerReadOnlyAttribute(attribute, null);
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{attribute}));
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new ConfigPropertyResourceDefinition(this.readOnly ? null : ConfigPropertyAdd.INSTANCE, (OperationStepHandler)(this.readOnly ? null : ReloadRequiredRemoveStepHandler.INSTANCE)));
        resourceRegistration.registerSubModel((ResourceDefinition)new ConnectionDefinitionResourceDefinition(this.readOnly, this.runtimeOnlyRegistrationValid));
        resourceRegistration.registerSubModel((ResourceDefinition)new AdminObjectResourceDefinition(this.readOnly));
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }
}

