/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.Arrays;
import java.util.Set;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.api.common.Security;
import org.jboss.as.connector.subsystems.jca.Constants;
import org.jboss.as.connector.subsystems.jca.JcaExtension;
import org.jboss.as.connector.subsystems.jca.WorkManagerAdd;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.threads.BoundedQueueThreadPoolAdd;
import org.jboss.as.threads.BoundedQueueThreadPoolRemove;
import org.jboss.as.threads.BoundedQueueThreadPoolResourceDefinition;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

public class JcaWorkManagerDefinition
extends SimpleResourceDefinition {
    protected static final PathElement PATH_WORK_MANAGER = PathElement.pathElement((String)"workmanager");
    private final boolean registerRuntimeOnly;

    private JcaWorkManagerDefinition(boolean registerRuntimeOnly) {
        super(PATH_WORK_MANAGER, (ResourceDescriptionResolver)JcaExtension.getResourceDescriptionResolver(PATH_WORK_MANAGER.getKey()), (OperationStepHandler)WorkManagerAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public static JcaWorkManagerDefinition createInstance(boolean registerRuntimeOnly) {
        return new JcaWorkManagerDefinition(registerRuntimeOnly);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)WmParameters.NAME.getAttribute(), (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)WmParameters.ELYTRON_ENABLED.getAttribute(), null, ModelOnlyWriteAttributeHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        JcaWorkManagerDefinition.registerSubModels(resourceRegistration, this.registerRuntimeOnly);
    }

    static void registerSubModels(ManagementResourceRegistration resourceRegistration, boolean runtimeOnly) {
        BoundedQueueThreadPoolAdd shortRunningThreadPoolAdd = new BoundedQueueThreadPoolAdd(true, ThreadsServices.STANDARD_THREAD_FACTORY_RESOLVER, ThreadsServices.STANDARD_HANDOFF_EXECUTOR_RESOLVER, ThreadsServices.EXECUTOR.append(new String[]{"short-running-threads"})){

            protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.populateModel(context, operation, resource);
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext oc, ModelNode op) throws OperationFailedException {
                        JcaWorkManagerDefinition.checkThreadPool(oc, op, "short-running-threads");
                    }
                }, OperationContext.Stage.MODEL);
            }
        };
        resourceRegistration.registerSubModel((ResourceDefinition)new JCAThreadPoolResourceDefinition(true, runtimeOnly, "short-running-threads", ThreadsServices.EXECUTOR.append(new String[]{"short-running-threads"}), "blocking-bounded-queue-thread-pool", (OperationStepHandler)shortRunningThreadPoolAdd, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE));
        BoundedQueueThreadPoolAdd longRunningThreadPoolAdd = new BoundedQueueThreadPoolAdd(true, ThreadsServices.STANDARD_THREAD_FACTORY_RESOLVER, ThreadsServices.STANDARD_HANDOFF_EXECUTOR_RESOLVER, ThreadsServices.EXECUTOR.append(new String[]{"long-running-threads"})){

            protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.populateModel(context, operation, resource);
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext oc, ModelNode op) throws OperationFailedException {
                        JcaWorkManagerDefinition.checkThreadPool(oc, op, "long-running-threads");
                    }
                }, OperationContext.Stage.MODEL);
            }
        };
        resourceRegistration.registerSubModel((ResourceDefinition)new JCAThreadPoolResourceDefinition(true, runtimeOnly, "long-running-threads", ThreadsServices.EXECUTOR.append(new String[]{"long-running-threads"}), "blocking-bounded-queue-thread-pool", (OperationStepHandler)longRunningThreadPoolAdd, (OperationStepHandler)new BoundedQueueThreadPoolRemove(longRunningThreadPoolAdd)));
    }

    private static void checkThreadPool(OperationContext context, ModelNode operation, String type) throws OperationFailedException {
        PathAddress threadPoolPath = context.getCurrentAddress();
        PathAddress workManagerPath = threadPoolPath.getParent();
        Set entrySet = context.readResourceFromRoot(workManagerPath, false).getChildrenNames(type);
        if (!entrySet.isEmpty() && !((String)entrySet.iterator().next()).equals(threadPoolPath.getLastElement().getValue())) {
            throw ConnectorLogger.ROOT_LOGGER.oneThreadPoolWorkManager(threadPoolPath.getLastElement().getValue(), type, workManagerPath.getLastElement().getValue());
        }
        if (!context.getCurrentAddressValue().equals(workManagerPath.getLastElement().getValue())) {
            throw ConnectorLogger.ROOT_LOGGER.threadPoolNameMustMatchWorkManagerName(threadPoolPath.getLastElement().getValue(), type, workManagerPath.getLastElement().getValue());
        }
    }

    public static enum WmParameters {
        NAME(((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING).setAllowExpression(false)).setRequired(true)).setMeasurementUnit(MeasurementUnit.NONE)).setRestartAllServices()).setXmlName("name")).build()),
        ELYTRON_ENABLED(((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("elytron-enabled", ModelType.BOOLEAN, true).setXmlName(Security.Tag.ELYTRON_ENABLED.getLocalName())).setAllowExpression(true)).setDefaultValue(new ModelNode(Constants.ELYTRON_MANAGED_SECURITY.booleanValue()))).setDeprecated(Constants.ELYTRON_BY_DEFAULT_VERSION)).build());

        private SimpleAttributeDefinition attribute;

        private WmParameters(SimpleAttributeDefinition attribute) {
            this.attribute = attribute;
        }

        public SimpleAttributeDefinition getAttribute() {
            return this.attribute;
        }

        static AttributeDefinition[] getAttributes() {
            return (AttributeDefinition[])Arrays.stream(WmParameters.values()).map(WmParameters::getAttribute).toArray(AttributeDefinition[]::new);
        }
    }

    private static class JCAThreadPoolResourceDefinition
    extends BoundedQueueThreadPoolResourceDefinition {
        protected JCAThreadPoolResourceDefinition(boolean blocking, boolean registerRuntimeOnly, String type, ServiceName serviceNameBase, String resolverPrefix, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
            super(blocking, registerRuntimeOnly, type, serviceNameBase, resolverPrefix, addHandler, removeHandler);
        }
    }
}

