/*
 * Decompiled with CFR 0.152.
 */
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedCommandBuilder;
import org.jboss.aesh.cl.internal.ProcessedOptionBuilder;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserBuilder;
import org.jboss.aesh.console.command.Command;

public class Main {
    public static final void main(String[] args) throws Exception {
        ProcessedCommand<?> options = Main.buildCommandLineOptions();
        CommandLineParser parser = new CommandLineParserBuilder().processedCommand(options).create();
        StringBuilder argLine = new StringBuilder("mycmd");
        for (String str : args) {
            argLine.append(' ').append(str);
        }
        CommandLine<Command> commandLine = parser.parse(argLine.toString());
        if (commandLine.getParserException() != null) {
            throw commandLine.getParserException();
        }
        System.out.println("hasOption(abc)=" + commandLine.hasOption("abc"));
        System.out.println("abc=" + commandLine.getOptionValue("abc", "<not set>"));
        System.out.println("hasOption(myoption)=" + commandLine.hasOption("myoption"));
        System.out.println("myoption=" + commandLine.getOptionValue("myoption", "<not set>"));
    }

    private static ProcessedCommand<?> buildCommandLineOptions() throws Exception {
        ProcessedCommandBuilder cmd = new ProcessedCommandBuilder();
        cmd.name("mycmd");
        cmd.addOption(new ProcessedOptionBuilder().name("abc").optionType(OptionType.NORMAL).type(String.class).create());
        cmd.addOption(new ProcessedOptionBuilder().name("myoption").optionType(OptionType.NORMAL).type(String.class).addDefaultValue("").create());
        return cmd.create();
    }
}

