/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.ssl.ALPNHackSSLEngine;
import io.undertow.protocols.ssl.SslConduit;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.AggregateConnectorStatistics;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.protocol.http.AlpnOpenListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.SslConnection;

public class JDK8HackAlpnOpenListener
implements ChannelListener<StreamConnection>,
AlpnOpenListener.AlpnDelegateListener {
    private final ByteBufferPool bufferPool;
    private final Map<String, ListenerEntry> listeners = new HashMap<String, ListenerEntry>();
    private final String fallbackProtocol;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private volatile boolean statisticsEnabled;
    public static boolean ENABLED = ALPNHackSSLEngine.ENABLED;

    public JDK8HackAlpnOpenListener(ByteBufferPool bufferPool, OptionMap undertowOptions, String fallbackProtocol, DelegateOpenListener fallbackListener) {
        this.bufferPool = bufferPool;
        this.fallbackProtocol = fallbackProtocol;
        if (fallbackProtocol != null && fallbackListener != null) {
            this.addProtocol(fallbackProtocol, fallbackListener, 0);
        }
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_STATISTICS, false);
        this.undertowOptions = undertowOptions;
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
        for (Map.Entry<String, ListenerEntry> delegate : this.listeners.entrySet()) {
            delegate.getValue().listener.setRootHandler(rootHandler);
        }
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
        for (Map.Entry<String, ListenerEntry> delegate : this.listeners.entrySet()) {
            delegate.getValue().listener.setRootHandler(this.rootHandler);
        }
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public ConnectorStatistics getConnectorStatistics() {
        if (this.statisticsEnabled) {
            ArrayList<ConnectorStatistics> stats = new ArrayList<ConnectorStatistics>();
            for (Map.Entry<String, ListenerEntry> l : this.listeners.entrySet()) {
                ConnectorStatistics c = l.getValue().listener.getConnectorStatistics();
                if (c == null) continue;
                stats.add(c);
            }
            return new AggregateConnectorStatistics(stats.toArray(new ConnectorStatistics[stats.size()]));
        }
        return null;
    }

    @Override
    public void addProtocol(String name, DelegateOpenListener listener, int weight) {
        this.listeners.put(name, new ListenerEntry(listener, weight, name));
    }

    public void handleEvent(StreamConnection channel) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", channel.getPeerAddress());
        }
        SslConduit sslConduit = UndertowXnioSsl.getSslConduit((SslConnection)channel);
        ALPNHackSSLEngine engine = new ALPNHackSSLEngine(sslConduit.getSSLEngine());
        sslConduit.setSslEngine(engine);
        AlpnConnectionListener potentialConnection = new AlpnConnectionListener(channel, engine);
        channel.getSourceChannel().setReadListener((ChannelListener)potentialConnection);
        ArrayList<String> protocols = new ArrayList<String>();
        ArrayList<ListenerEntry> entries = new ArrayList<ListenerEntry>(this.listeners.values());
        Collections.sort(entries);
        for (int i = 0; i < entries.size(); ++i) {
            protocols.add(((ListenerEntry)entries.get((int)i)).protocol);
        }
        engine.setApplicationProtocols(protocols);
        potentialConnection.handleEvent((StreamSourceChannel)channel.getSourceChannel());
    }

    private class AlpnConnectionListener
    implements ChannelListener<StreamSourceChannel> {
        private final StreamConnection channel;
        private final ALPNHackSSLEngine alpnsslEngine;

        private AlpnConnectionListener(StreamConnection channel, ALPNHackSSLEngine alpnsslEngine) {
            this.channel = channel;
            this.alpnsslEngine = alpnsslEngine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleEvent(StreamSourceChannel source) {
            PooledByteBuffer buffer = JDK8HackAlpnOpenListener.this.bufferPool.allocate();
            boolean free = true;
            try {
                while (true) {
                    int res;
                    if ((res = this.channel.getSourceChannel().read(buffer.getBuffer())) == -1) {
                        IoUtils.safeClose((Closeable)this.channel);
                        return;
                    }
                    buffer.getBuffer().flip();
                    String selected = this.alpnsslEngine.getSelectedApplicationProtocol();
                    if (selected != null) {
                        DelegateOpenListener listener;
                        if (selected.isEmpty()) {
                            if (JDK8HackAlpnOpenListener.this.fallbackProtocol == null) {
                                UndertowLogger.REQUEST_IO_LOGGER.noALPNFallback(this.channel.getPeerAddress());
                                IoUtils.safeClose((Closeable)this.channel);
                                return;
                            }
                            listener = ((ListenerEntry)((JDK8HackAlpnOpenListener)JDK8HackAlpnOpenListener.this).listeners.get((Object)((JDK8HackAlpnOpenListener)JDK8HackAlpnOpenListener.this).fallbackProtocol)).listener;
                        } else {
                            listener = ((ListenerEntry)((JDK8HackAlpnOpenListener)JDK8HackAlpnOpenListener.this).listeners.get((Object)selected)).listener;
                        }
                        source.getReadSetter().set(null);
                        listener.handleEvent(this.channel, buffer);
                        free = false;
                        return;
                    }
                    if (res > 0) {
                        if (JDK8HackAlpnOpenListener.this.fallbackProtocol == null) {
                            UndertowLogger.REQUEST_IO_LOGGER.noALPNFallback(this.channel.getPeerAddress());
                            IoUtils.safeClose((Closeable)this.channel);
                            return;
                        }
                        DelegateOpenListener listener = ((ListenerEntry)((JDK8HackAlpnOpenListener)JDK8HackAlpnOpenListener.this).listeners.get((Object)((JDK8HackAlpnOpenListener)JDK8HackAlpnOpenListener.this).fallbackProtocol)).listener;
                        source.getReadSetter().set(null);
                        listener.handleEvent(this.channel, buffer);
                        free = false;
                        return;
                    }
                    if (res == 0) {
                        this.channel.getSourceChannel().resumeReads();
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)this.channel);
                return;
            }
            finally {
                if (free) {
                    buffer.close();
                }
            }
        }
    }

    private static class ListenerEntry
    implements Comparable<ListenerEntry> {
        final DelegateOpenListener listener;
        final int weight;
        final String protocol;

        ListenerEntry(DelegateOpenListener listener, int weight, String protocol) {
            this.listener = listener;
            this.weight = weight;
            this.protocol = protocol;
        }

        @Override
        public int compareTo(ListenerEntry o) {
            return -Integer.compare(this.weight, o.weight);
        }
    }
}

