/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.uri.AbstractServerLocatorSchema;
import org.apache.activemq.artemis.uri.ConnectionOptions;
import org.apache.activemq.artemis.utils.uri.URISchema;

public class UDPServerLocatorSchema
extends AbstractServerLocatorSchema {
    protected static List<String> IGNORED = new ArrayList<String>();

    @Override
    public String getSchemaName() {
        return "udp";
    }

    @Override
    protected ServerLocator internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        ConnectionOptions options = this.newConnectionOptions(uri, query);
        DiscoveryGroupConfiguration dgc = UDPServerLocatorSchema.getDiscoveryGroupConfiguration(uri, query, this.getHost(uri), this.getPort(uri), name);
        if (options.isHa()) {
            return ActiveMQClient.createServerLocatorWithHA(dgc);
        }
        return ActiveMQClient.createServerLocatorWithoutHA(dgc);
    }

    @Override
    protected URI internalNewURI(ServerLocator bean) throws Exception {
        DiscoveryGroupConfiguration dgc = bean.getDiscoveryGroupConfiguration();
        UDPBroadcastEndpointFactory endpoint = (UDPBroadcastEndpointFactory)dgc.getBroadcastEndpointFactory();
        dgc.setBroadcastEndpointFactory(endpoint);
        String query = URISchema.getData(IGNORED, bean, dgc, endpoint);
        return new URI("udp", null, endpoint.getGroupAddress(), endpoint.getGroupPort(), null, query, null);
    }

    public static DiscoveryGroupConfiguration getDiscoveryGroupConfiguration(URI uri, Map<String, String> query, String host, int port, String name) throws Exception {
        UDPBroadcastEndpointFactory endpointFactoryConfiguration = new UDPBroadcastEndpointFactory().setGroupAddress(host).setGroupPort(port);
        URISchema.setData(uri, endpointFactoryConfiguration, query);
        DiscoveryGroupConfiguration dgc = URISchema.setData(uri, new DiscoveryGroupConfiguration(), query).setName(name).setBroadcastEndpointFactory(endpointFactoryConfiguration);
        URISchema.setData(uri, dgc, query);
        return dgc;
    }

    static {
        IGNORED.add("localBindAddress");
        IGNORED.add("localBindPort");
    }
}

