/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.persistence;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.rm.persistence.RMStoreException;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;

public final class PersistenceUtils {
    private static PersistenceUtils instance;
    private JAXBContext context;

    private PersistenceUtils() {
    }

    public static PersistenceUtils getInstance() {
        if (null == instance) {
            instance = new PersistenceUtils();
        }
        return instance;
    }

    public SequenceAcknowledgement deserialiseAcknowledgment(InputStream is) {
        Object obj = null;
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((InputStream)is);
        try {
            obj = this.getContext().createUnmarshaller().unmarshal(reader);
            if (obj instanceof JAXBElement) {
                JAXBElement el = (JAXBElement)obj;
                obj = el.getValue();
            }
        }
        catch (JAXBException ex) {
            throw new RMStoreException(ex);
        }
        finally {
            try {
                StaxUtils.close((XMLStreamReader)reader);
                is.close();
            }
            catch (Throwable t) {}
        }
        return (SequenceAcknowledgement)obj;
    }

    public InputStream serialiseAcknowledgment(SequenceAcknowledgement ack) {
        LoadingByteArrayOutputStream bos = new LoadingByteArrayOutputStream();
        try {
            this.getContext().createMarshaller().marshal((Object)ack, (OutputStream)bos);
        }
        catch (JAXBException ex) {
            throw new RMStoreException(ex);
        }
        return bos.createInputStream();
    }

    private JAXBContext getContext() throws JAXBException {
        if (null == this.context) {
            this.context = JAXBContext.newInstance((String)PackageUtils.getPackageName(SequenceAcknowledgement.class), (ClassLoader)this.getClass().getClassLoader());
        }
        return this.context;
    }
}

