/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;

public abstract class ElectionPolicyResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration> {
    static final PathElement WILDCARD_PATH = ElectionPolicyResourceDefinition.pathElement("*");
    private final Consumer<ResourceDescriptor> configurator;
    private final ResourceServiceBuilderFactory<SingletonElectionPolicy> builderFactory;

    static PathElement pathElement(String value) {
        return PathElement.pathElement((String)"election-policy", (String)value);
    }

    ElectionPolicyResourceDefinition(PathElement path, ResourceDescriptionResolver resolver, Consumer<ResourceDescriptor> configurator, ResourceServiceBuilderFactory<SingletonElectionPolicy> builderFactory) {
        super(path, resolver);
        this.configurator = configurator;
        this.builderFactory = builderFactory;
    }

    public void register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(Capability.class);
        this.configurator.accept(descriptor);
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler(this.builderFactory);
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register(registration);
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        NAME_PREFERENCES("name-preferences", "socket-binding-preferences"),
        SOCKET_BINDING_PREFERENCES("socket-binding-preferences", "name-preferences", (CapabilityReferenceRecorder)new CapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.ELECTION_POLICY, (UnaryRequirement)CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING));

        private final AttributeDefinition definition;

        private Attribute(String name, String alternative) {
            this.definition = Attribute.createBuilder(name, alternative).build();
        }

        private Attribute(String name, String alternative, CapabilityReferenceRecorder reference) {
            this.definition = ((StringListAttributeDefinition.Builder)Attribute.createBuilder(name, alternative).setCapabilityReference(reference)).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        private static StringListAttributeDefinition.Builder createBuilder(String name, String alternative) {
            return (StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(name).setAllowExpression(true)).setRequired(false)).setAlternatives(new String[]{alternative});
        }
    }

    static enum Capability implements org.jboss.as.clustering.controller.Capability
    {
        ELECTION_POLICY("org.wildfly.clustering.singleton.policy.election", SingletonElectionPolicy.class);

        private final RuntimeCapability<Void> definition;

        private Capability(String name, Class<?> type) {
            this.definition = RuntimeCapability.Builder.of((String)name, (boolean)true, type).build();
        }

        public RuntimeCapability<Void> getDefinition() {
            return this.definition;
        }

        public RuntimeCapability<Void> resolve(PathAddress address) {
            return this.definition.fromBaseCapability(address.getParent().getLastElement().getValue());
        }
    }
}

