/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.logging;

import java.io.Serializable;
import java.sql.Driver;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.spi.rar.NotFoundException;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;

public class ConnectorLogger_$logger
extends DelegatingBasicLogger
implements ConnectorLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConnectorLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String boundDataSource = "WFLYJCA0001: Bound data source [%s]";
    private static final String boundJca = "WFLYJCA0002: Bound JCA %s [%s]";
    private static final String cannotInstantiateDriverClass2 = "WFLYJCA0003: Unable to instantiate driver class \"%s\": %s";
    private static final String deployingCompliantJdbcDriver = "WFLYJCA0004: Deploying JDBC-compliant driver %s (version %d.%d)";
    private static final String deployingNonCompliantJdbcDriver = "WFLYJCA0005: Deploying non-JDBC-compliant driver %s (version %d.%d)";
    private static final String registeredAdminObject = "WFLYJCA0006: Registered admin object at %s";
    private static final String registeredConnectionFactory = "WFLYJCA0007: Registered connection factory %s";
    private static final String startingSubsystem = "WFLYJCA0009: Starting %s Subsystem (%s)";
    private static final String unboundDataSource = "WFLYJCA0010: Unbound data source [%s]";
    private static final String unboundJca = "WFLYJCA0011: Unbound JCA %s [%s]";
    private static final String driversElementNotSupported = "WFLYJCA0012: <drivers/> in standalone -ds.xml deployments aren't supported: Ignoring %s";
    private static final String driverNameAndResourceNameNotEquals = "WFLYJCA0015: the attribute driver-name (%s) cannot be different from driver resource name (%s)";
    private static final String methodNotFoundOnDataSource = "WFLYJCA0016: Method %s on DataSource class %s not found. Ignoring";
    private static final String forceIJToNull = "WFLYJCA0017: Forcing ironjacamar.xml descriptor to null";
    private static final String startedDriverService = "WFLYJCA0018: Started Driver service with driver-name = %s";
    private static final String stoppedDriverService = "WFLYJCA0019: Stopped Driver service with driver-name = %s";
    private static final String unsupportedSelectorOption = "WFLYJCA0020: Unsupported selector's option: %s";
    private static final String unsupportedPolicyOption = "WFLYJCA0021: Unsupported policy's option: %s";
    private static final String failedToStartJGroupsChannel = "WFLYJCA0022: Failed to start JGroups channel %s for distributed workmanager %s";
    private static final String failedToFindDistributedWorkManager = "WFLYJCA0023: Cannot find WorkManager %s or it isn't a distributed workmanager. Only DWM can override configurations";
    private static final String failedToStartDWMTransport = "WFLYJCA0024: Failed to start JGroups transport for distributed workmanager %s";
    private static final String unsupportedSelector = "WFLYJCA0025: Unsupported selector's option: %s";
    private static final String unsupportedPolicy = "WFLYJCA0026: Unsupported policy's option: %s";
    private static final String noSecurityDefined = "WFLYJCA0027: No ironjacamar.security defined for %s";
    private static final String connectionFactoryAnnotation = "WFLYJCA0028: @ConnectionFactoryDefinition will have limited management: %s";
    private static final String adminObjectAnnotation = "WFLYJCA0029: @AdministeredObjectDefinition will have limited management: %s";
    private static final String cannotDeploy = "WFLYJCA0030: unable to deploy";
    private static final String cannotDeployAndValidate = "WFLYJCA0031: unable to validate and deploy ds or xads";
    private static final String cannotStartDs = "WFLYJCA0032: Unable to start the ds because it generated more than one cf";
    private static final String deploymentError = "WFLYJCA0033: Error during the deployment of %s";
    private static final String cannotInstantiateDriverClass1 = "WFLYJCA0034: Unable to instantiate driver class \"%s\". See log (WARN) for more details";
    private static final String driverVersionMismatch = "WFLYJCA0035: Specified driver version doesn't match with actual driver version";
    private static final String failedToCreate = "WFLYJCA0036: Failed to create %s instance for [%s]%n reason: %s";
    private static final String failedToGetMetrics = "WFLYJCA0037: failed to get metrics: %s";
    private static final String failedToGetUrlDelimiter = "WFLYJCA0039: failed to get url delimiter";
    private static final String failedToInvokeOperation = "WFLYJCA0040: failed to invoke operation: %s";
    private static final String failedToLoadModuleDriver = "WFLYJCA0041: Failed to load module for driver [%s]";
    private static final String failedToMatchPool = "WFLYJCA0042: failed to match pool. Check JndiName: %s";
    private static final String failedToParseServiceXml = "WFLYJCA0043: Failed to parse service xml [%s]";
    private static final String failedToProcessRaChild = "WFLYJCA0044: Failed to process RA child archives for [%s]";
    private static final String failedToSetAttribute = "WFLYJCA0045: failed to set attribute: %s";
    private static final String failedToStartRaDeployment = "WFLYJCA0046: Failed to start RA deployment [%s]";
    private static final String invalidConnection = "WFLYJCA0047: Connection is not valid";
    private static final String jndiBindingsNotSupported = "WFLYJCA0049: Non-explicit JNDI bindings not supported";
    private static final String noMetricsAvailable = "WFLYJCA0050: no metrics available";
    private static final String notAnAnnotation = "WFLYJCA0051: %s should be an annotation";
    private static final String nullVar = "WFLYJCA0052: %s is null";
    private static final String serviceAlreadyStarted = "WFLYJCA0053: %s service [%s] is already started";
    private static final String serviceNotAvailable = "WFLYJCA0054: %s service [%s] is not available";
    private static final String serviceNotStarted = "WFLYJCA0056: Service not started";
    private static final String undefinedVar = "WFLYJCA0058: %s is undefined";
    private static final String failedToLoadNativeLibraries = "WFLYJCA0061: Failed to load native libraries";
    private static final String exceptionDeployingDatasource = "WFLYJCA0064: Exception deploying datasource %s";
    private static final String noDataSourceRegisteredForAddress = "WFLYJCA0065: No DataSource exists at address %s";
    private static final String unknownAttribute = "WFLYJCA0066: Unknown attribute %s";
    private static final String unknownOperation = "WFLYJCA0067: Unknown operation %s";
    private static final String xaDataSourcePropertiesNotPresent = "WFLYJCA0069: At least one xa-datasource-property is required for an xa-datasource";
    private static final String jndiNameRequired = "WFLYJCA0070: Jndi name is required";
    private static final String jndiNameInvalidFormat = "WFLYJCA0071: Jndi name have to start with java:/ or java:jboss/";
    private static final String deploymentFailed = "WFLYJCA0072: Deployment %s failed";
    private static final String failedToLoadModuleRA = "WFLYJCA0073: Failed to load module for RA [%s]";
    private static final String noSuchMethod = "WFLYJCA0074: Method %s not found";
    private static final String noSuchField = "WFLYJCA0075: Field %s not found";
    private static final String noPropertyResolution = "WFLYJCA0076: Unknown property resolution for property %s";
    private static final String archiveOrModuleRequired = "WFLYJCA0077: At least one of ARCHIVE or MODULE is required";
    private static final String compressedRarNotSupportedInModuleRA = "WFLYJCA0078: Rar are supported only in uncompressed form. Failed to load module for RA [%s]";
    private static final String FailedDeployDriverNotSpecified = "WFLYJCA0079: Failed to deploy datasource %s because driver is not specified";
    private static final String RARNotYetDeployed = "WFLYJCA0080: RAR '%s' not yet deployed.";
    private static final String invalidConnectionFactory = "WFLYJCA0083: Connection factory interface (%s) is incorrect for resource adapter '%s' while deploying %s";
    private static final String adminObjectForJCA10 = "WFLYJCA0084: Admin object declared for JCA 1.0 resource adapter '%s' while deploying %s";
    private static final String invalidAdminObject = "WFLYJCA0085: Admin object class (%s) is incorrect for resource adapter '%s' while deploying %s";
    private static final String cannotFindDriverClassName = "WFLYJCA0086: Unable to find driver class name in \"%s\" jar";
    private static final String unableToRegisterRecovery = "WFLYJCA0087: Unable to register recovery: %s (%s)";
    private static final String rejectAttributesMustBeTrue = "WFLYJCA0088: Attributes %s rejected. Must be true";
    private static final String exceptionDuringUnregistering = "WFLYJCA0089: Exception during unregistering deployment";
    private static final String jndiNameShouldValidate = "WFLYJCA0090: Jndi name shouldn't include '//' or end with '/'";
    private static final String deprecated = "WFLYJCA0091: -ds.xml file deployments are deprecated. Support may be removed in a future version.";
    private static final String indexedChildResourceRegistrationNotAvailable = "WFLYJCA0092: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    private static final String legacyDisableEnableOperation = "WFLYJCA0093: The '%s' operation is deprecated. Use of the 'add' or 'remove' operations is preferred, or if required the 'write-attribute' operation can used to set the deprecated 'enabled' attribute";
    private static final String errorDuringRecoveryShutdown = "WFLYJCA0096: Error during recovery shutdown";
    private static final String errorStoppingRA = "WFLYJCA0097: Exception while stopping resource adapter";
    private static final String boundNonJTADataSource = "WFLYJCA0098: Bound non-transactional data source: %s";
    private static final String unBoundNonJTADataSource = "WFLYJCA0099: Unbound non-transactional data source: %s";
    private static final String noSupportedOperation = "WFLYJCA0100: Operation %s is not supported";
    private static final String oneThreadPoolWorkManager = "WFLYJCA0101: Thread pool: %s(type: %s) can not be added for workmanager: %s, only one thread pool is allowed for each type.";
    private static final String attributeRequiresTrueAttribute = "WFLYJCA0102: Attribute %s can only be defined if %s is true";
    private static final String attributeRequiresFalseOrUndefinedAttribute = "WFLYJCA0103: Attribute %s can only be defined if %s is undefined or false";
    private static final String subject = "WFLYJCA0104: Subject=%s\nSubject identity=%s";
    private static final String elytronHandlerHandle = "WFLYJCA0106: Elytron handler handle: %s";
    private static final String executionSubjectNotSetInHandler = "WFLYJCA0107: Execution subject was not provided to the callback handler";
    private static final String invalidCallbackSecurityDomain = "WFLYJCA0108: Supplied callback doesn't contain a security domain reference";
    private static final String unsupportedCreateCallbackHandlerMethod = "WFLYJCA0109: Callback with security domain is required - use createCallbackHandler(Callback callback) instead";
    private static final String invalidCredentialSourceSupplier = "WFLYJCA0110: CredentialSourceSupplier is invalid for DSSecurity";
    private static final String invalidElytronWorkManagerSetting = "WFLYJCA0111: WorkManager hasn't elytron-enabled flag set accordingly with RA one";
    private static final String datasourceIsDisabled = "WFLYJCA0112: Datasource %s is disabled";
    private static final String unexceptedWorkerCompletionError = "WFLYJCA0113: Unexcepted error during worker execution : %s";

    public ConnectorLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void boundDataSource(String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.boundDataSource$str(), (Object)jndiName);
    }

    protected String boundDataSource$str() {
        return boundDataSource;
    }

    @Override
    public final void boundJca(String description, String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.boundJca$str(), (Object)description, (Object)jndiName);
    }

    protected String boundJca$str() {
        return boundJca;
    }

    @Override
    public final void cannotInstantiateDriverClass(String driverClassName, Throwable reason) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotInstantiateDriverClass2$str(), (Object)driverClassName, (Object)reason);
    }

    protected String cannotInstantiateDriverClass2$str() {
        return cannotInstantiateDriverClass2;
    }

    @Override
    public final void deployingCompliantJdbcDriver(Class<? extends Driver> driver, int majorVersion, int minorVersion) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.deployingCompliantJdbcDriver$str(), driver, (Object)majorVersion, (Object)minorVersion);
    }

    protected String deployingCompliantJdbcDriver$str() {
        return deployingCompliantJdbcDriver;
    }

    @Override
    public final void deployingNonCompliantJdbcDriver(Class<? extends Driver> driver, int majorVersion, int minorVersion) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.deployingNonCompliantJdbcDriver$str(), driver, (Object)majorVersion, (Object)minorVersion);
    }

    protected String deployingNonCompliantJdbcDriver$str() {
        return deployingNonCompliantJdbcDriver;
    }

    @Override
    public final void registeredAdminObject(String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.registeredAdminObject$str(), (Object)jndiName);
    }

    protected String registeredAdminObject$str() {
        return registeredAdminObject;
    }

    @Override
    public final void registeredConnectionFactory(String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.registeredConnectionFactory$str(), (Object)jndiName);
    }

    protected String registeredConnectionFactory$str() {
        return registeredConnectionFactory;
    }

    @Override
    public final void startingSubsystem(String subsystem, String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingSubsystem$str(), (Object)subsystem, (Object)version);
    }

    protected String startingSubsystem$str() {
        return startingSubsystem;
    }

    @Override
    public final void unboundDataSource(String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unboundDataSource$str(), (Object)jndiName);
    }

    protected String unboundDataSource$str() {
        return unboundDataSource;
    }

    @Override
    public final void unboundJca(String description, String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unboundJca$str(), (Object)description, (Object)jndiName);
    }

    protected String unboundJca$str() {
        return unboundJca;
    }

    @Override
    public final void driversElementNotSupported(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.driversElementNotSupported$str(), (Object)deploymentName);
    }

    protected String driversElementNotSupported$str() {
        return driversElementNotSupported;
    }

    protected String driverNameAndResourceNameNotEquals$str() {
        return driverNameAndResourceNameNotEquals;
    }

    @Override
    public final OperationFailedException driverNameAndResourceNameNotEquals(String driverName, String resourceName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.driverNameAndResourceNameNotEquals$str(), driverName, resourceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void methodNotFoundOnDataSource(String method, Class<?> clazz) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.methodNotFoundOnDataSource$str(), (Object)method, clazz);
    }

    protected String methodNotFoundOnDataSource$str() {
        return methodNotFoundOnDataSource;
    }

    @Override
    public final void forceIJToNull() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.forceIJToNull$str(), new Object[0]);
    }

    protected String forceIJToNull$str() {
        return forceIJToNull;
    }

    @Override
    public final void startedDriverService(String driverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startedDriverService$str(), (Object)driverName);
    }

    protected String startedDriverService$str() {
        return startedDriverService;
    }

    @Override
    public final void stoppedDriverService(String driverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stoppedDriverService$str(), (Object)driverName);
    }

    protected String stoppedDriverService$str() {
        return stoppedDriverService;
    }

    @Override
    public final void unsupportedSelectorOption(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsupportedSelectorOption$str(), (Object)name);
    }

    protected String unsupportedSelectorOption$str() {
        return unsupportedSelectorOption;
    }

    @Override
    public final void unsupportedPolicyOption(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsupportedPolicyOption$str(), (Object)name);
    }

    protected String unsupportedPolicyOption$str() {
        return unsupportedPolicyOption;
    }

    protected String failedToStartJGroupsChannel$str() {
        return failedToStartJGroupsChannel;
    }

    @Override
    public final StartException failedToStartJGroupsChannel(String channelName, String wmName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToStartJGroupsChannel$str(), channelName, wmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToFindDistributedWorkManager$str() {
        return failedToFindDistributedWorkManager;
    }

    @Override
    public final OperationFailedException failedToFindDistributedWorkManager(String wmName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.failedToFindDistributedWorkManager$str(), wmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToStartDWMTransport$str() {
        return failedToStartDWMTransport;
    }

    @Override
    public final StartException failedToStartDWMTransport(String wmName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToStartDWMTransport$str(), wmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedSelector$str() {
        return unsupportedSelector;
    }

    @Override
    public final OperationFailedException unsupportedSelector(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unsupportedSelector$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedPolicy$str() {
        return unsupportedPolicy;
    }

    @Override
    public final OperationFailedException unsupportedPolicy(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unsupportedPolicy$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void noSecurityDefined(String jndiName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noSecurityDefined$str(), (Object)jndiName);
    }

    protected String noSecurityDefined$str() {
        return noSecurityDefined;
    }

    @Override
    public final void connectionFactoryAnnotation(String jndiName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.connectionFactoryAnnotation$str(), (Object)jndiName);
    }

    protected String connectionFactoryAnnotation$str() {
        return connectionFactoryAnnotation;
    }

    @Override
    public final void adminObjectAnnotation(String jndiName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.adminObjectAnnotation$str(), (Object)jndiName);
    }

    protected String adminObjectAnnotation$str() {
        return adminObjectAnnotation;
    }

    protected String cannotDeploy$str() {
        return cannotDeploy;
    }

    @Override
    public final DeployException cannotDeploy(Throwable cause) {
        DeployException result = new DeployException(String.format(this.getLoggingLocale(), this.cannotDeploy$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeployAndValidate$str() {
        return cannotDeployAndValidate;
    }

    @Override
    public final DeployException cannotDeployAndValidate(Throwable cause) {
        DeployException result = new DeployException(String.format(this.getLoggingLocale(), this.cannotDeployAndValidate$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotStartDs$str() {
        return cannotStartDs;
    }

    @Override
    public final StartException cannotStartDs() {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.cannotStartDs$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String deploymentError$str() {
        return deploymentError;
    }

    @Override
    public final StartException deploymentError(Throwable cause, String name) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.deploymentError$str(), name), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInstantiateDriverClass1$str() {
        return cannotInstantiateDriverClass1;
    }

    @Override
    public final String cannotInstantiateDriverClass(String driverClassName) {
        return String.format(this.getLoggingLocale(), this.cannotInstantiateDriverClass1$str(), driverClassName);
    }

    protected String driverVersionMismatch$str() {
        return driverVersionMismatch;
    }

    @Override
    public final IllegalStateException driverVersionMismatch() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.driverVersionMismatch$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToCreate$str() {
        return failedToCreate;
    }

    @Override
    public final String failedToCreate(String type, ModelNode operation, String reasonMessage) {
        return String.format(this.getLoggingLocale(), this.failedToCreate$str(), type, operation, reasonMessage);
    }

    protected String failedToGetMetrics$str() {
        return failedToGetMetrics;
    }

    @Override
    public final String failedToGetMetrics(String message) {
        return String.format(this.getLoggingLocale(), this.failedToGetMetrics$str(), message);
    }

    protected String failedToGetUrlDelimiter$str() {
        return failedToGetUrlDelimiter;
    }

    @Override
    public final DeployException failedToGetUrlDelimiter(Throwable cause) {
        DeployException result = new DeployException(String.format(this.getLoggingLocale(), this.failedToGetUrlDelimiter$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToInvokeOperation$str() {
        return failedToInvokeOperation;
    }

    @Override
    public final String failedToInvokeOperation(String message) {
        return String.format(this.getLoggingLocale(), this.failedToInvokeOperation$str(), message);
    }

    protected String failedToLoadModuleDriver$str() {
        return failedToLoadModuleDriver;
    }

    @Override
    public final String failedToLoadModuleDriver(String moduleName) {
        return String.format(this.getLoggingLocale(), this.failedToLoadModuleDriver$str(), moduleName);
    }

    protected String failedToMatchPool$str() {
        return failedToMatchPool;
    }

    @Override
    public final IllegalArgumentException failedToMatchPool(String jndiName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failedToMatchPool$str(), jndiName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToParseServiceXml$str() {
        return failedToParseServiceXml;
    }

    @Override
    public final DeploymentUnitProcessingException failedToParseServiceXml(VirtualFile xmlFile) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToParseServiceXml$str(), xmlFile));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final DeploymentUnitProcessingException failedToParseServiceXml(Throwable cause, VirtualFile xmlFile) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToParseServiceXml$str(), xmlFile), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToProcessRaChild$str() {
        return failedToProcessRaChild;
    }

    @Override
    public final DeploymentUnitProcessingException failedToProcessRaChild(Throwable cause, VirtualFile deploymentRoot) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToProcessRaChild$str(), deploymentRoot), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToSetAttribute$str() {
        return failedToSetAttribute;
    }

    @Override
    public final String failedToSetAttribute(String message) {
        return String.format(this.getLoggingLocale(), this.failedToSetAttribute$str(), message);
    }

    protected String failedToStartRaDeployment$str() {
        return failedToStartRaDeployment;
    }

    @Override
    public final StartException failedToStartRaDeployment(Throwable cause, String deploymentName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToStartRaDeployment$str(), deploymentName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConnection$str() {
        return invalidConnection;
    }

    @Override
    public final IllegalStateException invalidConnection() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidConnection$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jndiBindingsNotSupported$str() {
        return jndiBindingsNotSupported;
    }

    @Override
    public final IllegalStateException jndiBindingsNotSupported() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.jndiBindingsNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noMetricsAvailable$str() {
        return noMetricsAvailable;
    }

    @Override
    public final String noMetricsAvailable() {
        return String.format(this.getLoggingLocale(), this.noMetricsAvailable$str(), new Object[0]);
    }

    protected String notAnAnnotation$str() {
        return notAnAnnotation;
    }

    @Override
    public final IllegalArgumentException notAnAnnotation(Class<?> clazz) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.notAnAnnotation$str(), clazz));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullVar$str() {
        return nullVar;
    }

    @Override
    public final String nullVar(String name) {
        return String.format(this.getLoggingLocale(), this.nullVar$str(), name);
    }

    protected String serviceAlreadyStarted$str() {
        return serviceAlreadyStarted;
    }

    @Override
    public final String serviceAlreadyStarted(String serviceType, Object obj) {
        return String.format(this.getLoggingLocale(), this.serviceAlreadyStarted$str(), serviceType, obj);
    }

    protected String serviceNotAvailable$str() {
        return serviceNotAvailable;
    }

    @Override
    public final String serviceNotAvailable(String serviceType, Object obj) {
        return String.format(this.getLoggingLocale(), this.serviceNotAvailable$str(), serviceType, obj);
    }

    protected String serviceNotStarted$str() {
        return serviceNotStarted;
    }

    @Override
    public final IllegalStateException serviceNotStarted() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceNotStarted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String undefinedVar$str() {
        return undefinedVar;
    }

    @Override
    public final IllegalArgumentException undefinedVar(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.undefinedVar$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToLoadNativeLibraries$str() {
        return failedToLoadNativeLibraries;
    }

    @Override
    public final DeploymentUnitProcessingException failedToLoadNativeLibraries(Throwable cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToLoadNativeLibraries$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String exceptionDeployingDatasource$str() {
        return exceptionDeployingDatasource;
    }

    @Override
    public final DeploymentUnitProcessingException exceptionDeployingDatasource(Throwable cause, String datasource) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.exceptionDeployingDatasource$str(), datasource), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDataSourceRegisteredForAddress$str() {
        return noDataSourceRegisteredForAddress;
    }

    @Override
    public final String noDataSourceRegisteredForAddress(PathAddress address) {
        return String.format(this.getLoggingLocale(), this.noDataSourceRegisteredForAddress$str(), address);
    }

    protected String unknownAttribute$str() {
        return unknownAttribute;
    }

    @Override
    public final IllegalStateException unknownAttribute(String attributeName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownAttribute$str(), attributeName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownOperation$str() {
        return unknownOperation;
    }

    @Override
    public final IllegalStateException unknownOperation(String attributeName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownOperation$str(), attributeName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String xaDataSourcePropertiesNotPresent$str() {
        return xaDataSourcePropertiesNotPresent;
    }

    @Override
    public final OperationFailedException xaDataSourcePropertiesNotPresent() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.xaDataSourcePropertiesNotPresent$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jndiNameRequired$str() {
        return jndiNameRequired;
    }

    @Override
    public final OperationFailedException jndiNameRequired() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.jndiNameRequired$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jndiNameInvalidFormat$str() {
        return jndiNameInvalidFormat;
    }

    @Override
    public final OperationFailedException jndiNameInvalidFormat() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.jndiNameInvalidFormat$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String deploymentFailed$str() {
        return deploymentFailed;
    }

    @Override
    public final DeployException deploymentFailed(Throwable cause, String className) {
        DeployException result = new DeployException(String.format(this.getLoggingLocale(), this.deploymentFailed$str(), className), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToLoadModuleRA$str() {
        return failedToLoadModuleRA;
    }

    @Override
    public final String failedToLoadModuleRA(String moduleName) {
        return String.format(this.getLoggingLocale(), this.failedToLoadModuleRA$str(), moduleName);
    }

    protected String noSuchMethod$str() {
        return noSuchMethod;
    }

    @Override
    public final NoSuchMethodException noSuchMethod(String name) {
        NoSuchMethodException result = new NoSuchMethodException(String.format(this.getLoggingLocale(), this.noSuchMethod$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchField$str() {
        return noSuchField;
    }

    @Override
    public final NoSuchMethodException noSuchField(String name) {
        NoSuchMethodException result = new NoSuchMethodException(String.format(this.getLoggingLocale(), this.noSuchField$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noPropertyResolution$str() {
        return noPropertyResolution;
    }

    @Override
    public final IllegalArgumentException noPropertyResolution(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noPropertyResolution$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String archiveOrModuleRequired$str() {
        return archiveOrModuleRequired;
    }

    @Override
    public final OperationFailedException archiveOrModuleRequired() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.archiveOrModuleRequired$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String compressedRarNotSupportedInModuleRA$str() {
        return compressedRarNotSupportedInModuleRA;
    }

    @Override
    public final String compressedRarNotSupportedInModuleRA(String moduleName) {
        return String.format(this.getLoggingLocale(), this.compressedRarNotSupportedInModuleRA$str(), moduleName);
    }

    protected String FailedDeployDriverNotSpecified$str() {
        return FailedDeployDriverNotSpecified;
    }

    @Override
    public final DeploymentUnitProcessingException FailedDeployDriverNotSpecified(String dsName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.FailedDeployDriverNotSpecified$str(), dsName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String RARNotYetDeployed$str() {
        return RARNotYetDeployed;
    }

    @Override
    public final OperationFailedException RARNotYetDeployed(String raName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.RARNotYetDeployed$str(), raName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConnectionFactory$str() {
        return invalidConnectionFactory;
    }

    @Override
    public final DeploymentUnitProcessingException invalidConnectionFactory(String cf, String ra, String jndiName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.invalidConnectionFactory$str(), cf, ra, jndiName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String adminObjectForJCA10$str() {
        return adminObjectForJCA10;
    }

    @Override
    public final DeploymentUnitProcessingException adminObjectForJCA10(String ra, String jndiName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.adminObjectForJCA10$str(), ra, jndiName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAdminObject$str() {
        return invalidAdminObject;
    }

    @Override
    public final DeploymentUnitProcessingException invalidAdminObject(String ao, String ra, String jndiName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.invalidAdminObject$str(), ao, ra, jndiName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void cannotFindDriverClassName(String driverName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotFindDriverClassName$str(), (Object)driverName);
    }

    protected String cannotFindDriverClassName$str() {
        return cannotFindDriverClassName;
    }

    @Override
    public final void unableToRegisterRecovery(String key, boolean isXa) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unableToRegisterRecovery$str(), (Object)key, (Object)isXa);
    }

    protected String unableToRegisterRecovery$str() {
        return unableToRegisterRecovery;
    }

    protected String rejectAttributesMustBeTrue$str() {
        return rejectAttributesMustBeTrue;
    }

    @Override
    public final String rejectAttributesMustBeTrue(Set<String> key) {
        return String.format(this.getLoggingLocale(), this.rejectAttributesMustBeTrue$str(), key);
    }

    @Override
    public final void exceptionDuringUnregistering(NotFoundException nfe) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)nfe, this.exceptionDuringUnregistering$str(), new Object[0]);
    }

    protected String exceptionDuringUnregistering$str() {
        return exceptionDuringUnregistering;
    }

    protected String jndiNameShouldValidate$str() {
        return jndiNameShouldValidate;
    }

    @Override
    public final OperationFailedException jndiNameShouldValidate() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.jndiNameShouldValidate$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void deprecated() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.deprecated$str(), new Object[0]);
    }

    protected String deprecated$str() {
        return deprecated;
    }

    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return indexedChildResourceRegistrationNotAvailable;
    }

    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(PathElement address) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.indexedChildResourceRegistrationNotAvailable$str(), address));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void legacyDisableEnableOperation(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.legacyDisableEnableOperation$str(), (Object)name);
    }

    protected String legacyDisableEnableOperation$str() {
        return legacyDisableEnableOperation;
    }

    @Override
    public final void errorDuringRecoveryShutdown(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorDuringRecoveryShutdown$str(), new Object[0]);
    }

    protected String errorDuringRecoveryShutdown$str() {
        return errorDuringRecoveryShutdown;
    }

    @Override
    public final void errorStoppingRA(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.errorStoppingRA$str(), new Object[0]);
    }

    protected String errorStoppingRA$str() {
        return errorStoppingRA;
    }

    @Override
    public final void boundNonJTADataSource(String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.boundNonJTADataSource$str(), (Object)jndiName);
    }

    protected String boundNonJTADataSource$str() {
        return boundNonJTADataSource;
    }

    @Override
    public final void unBoundNonJTADataSource(String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unBoundNonJTADataSource$str(), (Object)jndiName);
    }

    protected String unBoundNonJTADataSource$str() {
        return unBoundNonJTADataSource;
    }

    protected String noSupportedOperation$str() {
        return noSupportedOperation;
    }

    @Override
    public final UnsupportedOperationException noSupportedOperation(String operation) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.noSupportedOperation$str(), operation));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String oneThreadPoolWorkManager$str() {
        return oneThreadPoolWorkManager;
    }

    @Override
    public final OperationFailedException oneThreadPoolWorkManager(String threadPoolName, String threadPoolType, String workManagerName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.oneThreadPoolWorkManager$str(), threadPoolName, threadPoolType, workManagerName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributeRequiresTrueAttribute$str() {
        return attributeRequiresTrueAttribute;
    }

    @Override
    public final OperationFailedException attributeRequiresTrueAttribute(String attribute, String requiredAttribute) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.attributeRequiresTrueAttribute$str(), attribute, requiredAttribute));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributeRequiresFalseOrUndefinedAttribute$str() {
        return attributeRequiresFalseOrUndefinedAttribute;
    }

    @Override
    public final OperationFailedException attributeRequiresFalseOrUndefinedAttribute(String attribute, String requiredFalseAttribute) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.attributeRequiresFalseOrUndefinedAttribute$str(), attribute, requiredFalseAttribute));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String subject$str() {
        return subject;
    }

    @Override
    public final String subject(Subject subject, String identity) {
        return String.format(this.getLoggingLocale(), this.subject$str(), subject, identity);
    }

    @Override
    public final void elytronHandlerHandle(String callbacks) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.elytronHandlerHandle$str(), (Object)callbacks);
    }

    protected String elytronHandlerHandle$str() {
        return elytronHandlerHandle;
    }

    protected String executionSubjectNotSetInHandler$str() {
        return executionSubjectNotSetInHandler;
    }

    @Override
    public final SecurityException executionSubjectNotSetInHandler() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.executionSubjectNotSetInHandler$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCallbackSecurityDomain$str() {
        return invalidCallbackSecurityDomain;
    }

    @Override
    public final IllegalArgumentException invalidCallbackSecurityDomain() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidCallbackSecurityDomain$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedCreateCallbackHandlerMethod$str() {
        return unsupportedCreateCallbackHandlerMethod;
    }

    @Override
    public final UnsupportedOperationException unsupportedCreateCallbackHandlerMethod() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedCreateCallbackHandlerMethod$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCredentialSourceSupplier$str() {
        return invalidCredentialSourceSupplier;
    }

    @Override
    public final IllegalStateException invalidCredentialSourceSupplier(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidCredentialSourceSupplier$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidElytronWorkManagerSetting$str() {
        return invalidElytronWorkManagerSetting;
    }

    @Override
    public final IllegalStateException invalidElytronWorkManagerSetting() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidElytronWorkManagerSetting$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String datasourceIsDisabled$str() {
        return datasourceIsDisabled;
    }

    @Override
    public final IllegalArgumentException datasourceIsDisabled(String jndiName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.datasourceIsDisabled$str(), jndiName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unexceptedWorkerCompletionError(String errorMessage, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unexceptedWorkerCompletionError$str(), (Object)errorMessage);
    }

    protected String unexceptedWorkerCompletionError$str() {
        return unexceptedWorkerCompletionError;
    }
}

