/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.List;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.web.infinispan.session.Scheduler;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class CompositeScheduler
implements Scheduler {
    private final List<Scheduler> schedulers;

    public CompositeScheduler(List<Scheduler> schedulers) {
        this.schedulers = schedulers;
    }

    @Override
    public void schedule(String sessionId, ImmutableSessionMetaData metaData) {
        for (Scheduler scheduler : this.schedulers) {
            scheduler.schedule(sessionId, metaData);
        }
    }

    @Override
    public void cancel(String sessionId) {
        for (Scheduler scheduler : this.schedulers) {
            scheduler.cancel(sessionId);
        }
    }

    @Override
    public void cancel(Locality locality) {
        for (Scheduler scheduler : this.schedulers) {
            scheduler.cancel(locality);
        }
    }

    @Override
    public void close() {
        for (Scheduler scheduler : this.schedulers) {
            scheduler.close();
        }
    }
}

