/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.h2.compress.CompressLZF;
import org.h2.util.MathUtils;

class FileMemData {
    private static final int CACHE_SIZE = 8;
    private static final int BLOCK_SIZE_SHIFT = 10;
    private static final int BLOCK_SIZE = 1024;
    private static final int BLOCK_SIZE_MASK = 1023;
    private static final CompressLZF LZF = new CompressLZF();
    private static final byte[] BUFFER = new byte[2048];
    private static final byte[] COMPRESSED_EMPTY_BLOCK;
    private static final Cache<CompressItem, CompressItem> COMPRESS_LATER;
    private String name;
    private final int id;
    private final boolean compress;
    private long length;
    private byte[][] data;
    private long lastModified;
    private boolean isReadOnly;
    private boolean isLockedExclusive;
    private int sharedLockCount;

    FileMemData(String string, boolean bl) {
        this.name = string;
        this.id = string.hashCode();
        this.compress = bl;
        this.data = new byte[0][];
        this.lastModified = System.currentTimeMillis();
    }

    int getId() {
        return this.id;
    }

    synchronized boolean lockExclusive() {
        if (this.sharedLockCount > 0 || this.isLockedExclusive) {
            return false;
        }
        this.isLockedExclusive = true;
        return true;
    }

    synchronized boolean lockShared() {
        if (this.isLockedExclusive) {
            return false;
        }
        ++this.sharedLockCount;
        return true;
    }

    synchronized void unlock() {
        if (this.isLockedExclusive) {
            this.isLockedExclusive = false;
        } else {
            this.sharedLockCount = Math.max(0, this.sharedLockCount - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressLater(int n) {
        CompressItem compressItem = new CompressItem();
        compressItem.file = this;
        compressItem.page = n;
        compressItem.data = this.data[n];
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            COMPRESS_LATER.put(compressItem, compressItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expand(int n) {
        byte[] byArray = this.data[n];
        if (byArray.length == 1024) {
            return;
        }
        byte[] byArray2 = new byte[1024];
        if (byArray != COMPRESSED_EMPTY_BLOCK) {
            CompressLZF compressLZF = LZF;
            synchronized (compressLZF) {
                LZF.expand(byArray, 0, byArray.length, byArray2, 0, 1024);
            }
        }
        this.data[n] = byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compress(int n, byte[] byArray) {
        byte[][] byArray2 = this.data;
        if (n >= byArray2.length) {
            return;
        }
        byte[] byArray3 = byArray2[n];
        if (byArray3 != byArray) {
            return;
        }
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            int n2 = LZF.compress(byArray3, 1024, BUFFER, 0);
            if (n2 <= 1024) {
                byArray3 = new byte[n2];
                System.arraycopy(BUFFER, 0, byArray3, 0, n2);
                byte[] byArray4 = byArray2[n];
                if (byArray4 != byArray) {
                    return;
                }
                byArray2[n] = byArray3;
            }
        }
    }

    void touch(boolean bl) throws IOException {
        if (this.isReadOnly || bl) {
            throw new IOException("Read only");
        }
        this.lastModified = System.currentTimeMillis();
    }

    long length() {
        return this.length;
    }

    void truncate(long l) {
        this.changeLength(l);
        long l2 = MathUtils.roundUpLong(l, 1024L);
        if (l2 != l) {
            int n = (int)(l >>> 10);
            this.expand(n);
            byte[] byArray = this.data[n];
            for (int i = (int)(l & 0x3FFL); i < 1024; ++i) {
                byArray[i] = 0;
            }
            if (this.compress) {
                this.compressLater(n);
            }
        }
    }

    private void changeLength(long l) {
        this.length = l;
        int n = (int)((l = MathUtils.roundUpLong(l, 1024L)) >>> 10);
        if (n != this.data.length) {
            byte[][] byArrayArray = new byte[n][];
            System.arraycopy(this.data, 0, byArrayArray, 0, Math.min(this.data.length, byArrayArray.length));
            for (int i = this.data.length; i < n; ++i) {
                byArrayArray[i] = COMPRESSED_EMPTY_BLOCK;
            }
            this.data = byArrayArray;
        }
    }

    long readWrite(long l, byte[] byArray, int n, int n2, boolean bl) {
        long l2 = l + (long)n2;
        if (l2 > this.length) {
            if (bl) {
                this.changeLength(l2);
            } else {
                n2 = (int)(this.length - l);
            }
        }
        while (n2 > 0) {
            int n3 = (int)Math.min((long)n2, 1024L - (l & 0x3FFL));
            int n4 = (int)(l >>> 10);
            this.expand(n4);
            byte[] byArray2 = this.data[n4];
            int n5 = (int)(l & 0x3FFL);
            if (bl) {
                System.arraycopy(byArray, n, byArray2, n5, n3);
            } else {
                System.arraycopy(byArray2, n5, byArray, n, n3);
            }
            if (this.compress) {
                this.compressLater(n4);
            }
            n += n3;
            l += (long)n3;
            n2 -= n3;
        }
        return l;
    }

    void setName(String string) {
        this.name = string;
    }

    String getName() {
        return this.name;
    }

    long getLastModified() {
        return this.lastModified;
    }

    boolean canWrite() {
        return !this.isReadOnly;
    }

    boolean setReadOnly() {
        this.isReadOnly = true;
        return true;
    }

    static {
        COMPRESS_LATER = new Cache(8);
        byte[] byArray = new byte[1024];
        int n = LZF.compress(byArray, 1024, BUFFER, 0);
        COMPRESSED_EMPTY_BLOCK = new byte[n];
        System.arraycopy(BUFFER, 0, COMPRESSED_EMPTY_BLOCK, 0, n);
    }

    static class CompressItem {
        FileMemData file;
        byte[] data;
        int page;

        CompressItem() {
        }

        public int hashCode() {
            return this.page ^ this.file.getId();
        }

        public boolean equals(Object object) {
            if (object instanceof CompressItem) {
                CompressItem compressItem = (CompressItem)object;
                return compressItem.page == this.page && compressItem.file == this.file;
            }
            return false;
        }
    }

    static class Cache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int size;

        Cache(int n) {
            super(n, 0.75f, true);
            this.size = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            if (this.size() < this.size) {
                return false;
            }
            CompressItem compressItem = (CompressItem)entry.getKey();
            compressItem.file.compress(compressItem.page, compressItem.data);
            return true;
        }
    }
}

