/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.spnego.encoding;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.security.negotiation.spnego.encoding.SPNEGOMessage;

public class NegTokenDecoder {
    public static int readLength(InputStream is) throws IOException {
        byte first = (byte)is.read();
        byte masked = (byte)(first & 0xFFFFFF80);
        if (masked == 0) {
            return first;
        }
        int lengthLength = first & 0x7F;
        byte[] lengthBytes = new byte[lengthLength];
        is.read(lengthBytes);
        int length = 0;
        for (int i = 0; i < lengthLength; ++i) {
            int currentPos = lengthLength - i - 1;
            int currentLength = lengthBytes[currentPos];
            if (currentLength < 0) {
                currentLength += 256;
            }
            if (i > 0) {
                currentLength *= (int)Math.pow(2.0, 8 * i);
            }
            length += currentLength;
        }
        return length;
    }

    static void decodeMechListMIC(InputStream is, SPNEGOMessage spnegoMessage) throws IOException {
        int length = NegTokenDecoder.readLength(is);
        byte[] mechListMIC = new byte[length];
        is.read(mechListMIC);
        spnegoMessage.setMechListMIC(mechListMIC);
    }
}

