/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.topology.CacheTopology;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.GroupListener;
import org.wildfly.clustering.group.Membership;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.group.CacheGroupConfiguration;
import org.wildfly.clustering.server.group.CacheMembership;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.group.SingletonMembership;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.service.concurrent.ClassLoaderThreadFactory;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class CacheGroup
implements Group<Address>,
AutoCloseable {
    private final Map<GroupListener, ExecutorService> listeners = new ConcurrentHashMap<GroupListener, ExecutorService>();
    private final Cache<?, ?> cache;
    private final NodeFactory<org.jgroups.Address> nodeFactory;
    private final SortedMap<Integer, Boolean> views = Collections.synchronizedSortedMap(new TreeMap());

    private static ThreadFactory createThreadFactory(Class<?> targetClass) {
        PrivilegedAction<ThreadFactory> action = () -> new JBossThreadFactory(new ThreadGroup(targetClass.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        return new ClassLoaderThreadFactory((ThreadFactory)WildFlySecurityManager.doUnchecked(action), targetClass.getClassLoader());
    }

    public CacheGroup(CacheGroupConfiguration config) {
        this.cache = config.getCache();
        this.nodeFactory = config.getMemberFactory();
        this.cache.getCacheManager().addListener((Object)this);
        this.cache.addListener((Object)this);
    }

    @Override
    public void close() {
        this.cache.removeListener((Object)this);
        this.cache.getCacheManager().removeListener((Object)this);
        this.listeners.values().forEach(executor -> {
            PrivilegedAction<List> action = () -> executor.shutdownNow();
            WildFlySecurityManager.doUnchecked(action);
        });
        this.listeners.clear();
    }

    public String getName() {
        GlobalConfiguration global = this.cache.getCacheManager().getCacheManagerConfiguration();
        TransportConfiguration transport = global.transport();
        return transport.transport() != null ? transport.clusterName() : global.globalJmxStatistics().cacheManagerName();
    }

    public Node getLocalMember() {
        return this.createNode(this.cache.getCacheManager().getAddress());
    }

    public Membership getMembership() {
        if (this.isSingleton()) {
            return new SingletonMembership(this.getLocalMember());
        }
        Transport transport = this.cache.getCacheManager().getTransport();
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        return dist != null ? new CacheMembership(transport.getAddress(), (CacheTopology)dist.getCacheTopology(), (NodeFactory<Address>)this) : new CacheMembership(transport, this);
    }

    public boolean isSingleton() {
        return this.cache.getCacheManager().getTransport() == null;
    }

    public Node createNode(Address address) {
        return this.nodeFactory.createNode((Object)CacheGroup.toJGroupsAddress(address));
    }

    private static org.jgroups.Address toJGroupsAddress(Address address) {
        if (address == null) {
            return null;
        }
        if (address instanceof JGroupsAddress) {
            JGroupsAddress jgroupsAddress = (JGroupsAddress)address;
            return jgroupsAddress.getJGroupsAddress();
        }
        throw new IllegalArgumentException(address.toString());
    }

    @Merged
    @ViewChanged
    public void viewChanged(ViewChangedEvent event) {
        if (this.cache.getAdvancedCache().getDistributionManager() != null) {
            this.views.put(event.getViewId(), event.isMergeView());
        } else if (!this.listeners.isEmpty()) {
            CacheMembership previousMembership = new CacheMembership(event.getLocalAddress(), event.getOldMembers(), (NodeFactory<Address>)this);
            CacheMembership membership = new CacheMembership(event.getLocalAddress(), event.getNewMembers(), (NodeFactory<Address>)this);
            for (Map.Entry<GroupListener, ExecutorService> entry : this.listeners.entrySet()) {
                GroupListener listener = entry.getKey();
                ExecutorService executor = entry.getValue();
                try {
                    executor.submit(() -> {
                        try {
                            listener.membershipChanged(previousMembership, membership, event.isMergeView());
                        }
                        catch (Throwable e) {
                            ClusteringServerLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
        }
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<?, ?> event) {
        if (event.isPre()) {
            return;
        }
        int viewId = event.getCache().getCacheManager().getTransport().getViewId();
        if (!this.listeners.isEmpty()) {
            Address localAddress = event.getCache().getCacheManager().getAddress();
            CacheMembership previousMembership = new CacheMembership(localAddress, event.getWriteConsistentHashAtStart(), (NodeFactory<Address>)this);
            CacheMembership membership = new CacheMembership(localAddress, event.getWriteConsistentHashAtEnd(), (NodeFactory<Address>)this);
            Boolean status = (Boolean)this.views.get(viewId);
            boolean merged = status != null ? status : false;
            for (Map.Entry<GroupListener, ExecutorService> entry : this.listeners.entrySet()) {
                GroupListener listener = entry.getKey();
                ExecutorService executor = entry.getValue();
                try {
                    executor.submit(() -> {
                        try {
                            listener.membershipChanged(previousMembership, membership, merged);
                        }
                        catch (Throwable e) {
                            ClusteringServerLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
        }
        this.views.headMap(viewId).clear();
    }

    public Registration register(GroupListener listener) {
        this.listeners.computeIfAbsent(listener, key -> Executors.newSingleThreadExecutor(CacheGroup.createThreadFactory(listener.getClass())));
        return () -> this.unregister(listener);
    }

    private void unregister(GroupListener listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            PrivilegedAction<List> action = () -> executor.shutdownNow();
            WildFlySecurityManager.doUnchecked(action);
            try {
                executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Deprecated
    public void removeListener(Group.Listener listener) {
        this.unregister((GroupListener)listener);
    }
}

